﻿using System;
using System.Xml;
using Oni.Metadata;
using Oni.Xml;

namespace Oni.Objects
{
    internal class Turret : GunkObject
    {
        public int ScriptId;
        public TurretFlags Flags;
        public TurretTargetTeams TargetTeams;

        public Turret()
        {
            TypeId = ObjectType.Turret;
        }

        protected override void WriteOsd(BinaryWriter writer)
        {
            writer.Write(ClassName, 63);
            writer.WriteUInt16(ScriptId);
            writer.WriteUInt16((ushort)Flags);
            writer.Skip(36);
            writer.Write((uint)TargetTeams);
        }

        protected override void ReadOsd(BinaryReader reader)
        {
            ClassName = reader.ReadString(63);
            ScriptId = reader.ReadUInt16();
            Flags = (TurretFlags)reader.ReadUInt16();
            reader.Skip(36);
            TargetTeams = (TurretTargetTeams)reader.ReadInt32();
        }

        protected override void WriteOsd(XmlWriter xml)
        {
            xml.WriteElementString("Class", ClassName);
            xml.WriteElementString("TurretId", XmlConvert.ToString(ScriptId));
            xml.WriteElementString("Flags", MetaEnum.ToString<TurretFlags>(Flags));
            xml.WriteElementString("TargetedTeams", MetaEnum.ToString<TurretTargetTeams>(TargetTeams));
        }

        protected override void ReadOsd(XmlReader xml, ObjectLoadContext context)
        {
            string className = xml.ReadElementContentAsString("Class", "");

            ScriptId = xml.ReadElementContentAsInt("TurretId", "");
            Flags = xml.ReadElementContentAsEnum<TurretFlags>("Flags");
            TargetTeams = xml.ReadElementContentAsEnum<TurretTargetTeams>("TargetedTeams");

            GunkClass = context.GetClass(TemplateTag.TURR, className, TurretClass.Read);
        }
    }
}
