﻿using System;
using System.Collections.Generic;
using Oni.Akira;
using Oni.Motoko;
using Oni.Physics;

namespace Oni.Objects
{
    internal class TurretClass : GunkObjectClass
    {
        public string BaseName;
        public int Flags;
        public int FreeTime;
        public int ReloadTime;
        public int BarrelCount;
        public int RecoilAnimType;
        public int ReloadAnimType;
        public int MaxAmmo;
        public int AttachmentCount;
        public int ShooterCount;
        public float AimingSpeed;
        public Geometry BaseGeometry;
        public GunkFlags BaseGunkFlags;
        public Geometry TurretGeometry;
        public GunkFlags TurretGunkFlags;
        public Geometry BarrelGeometry;
        public GunkFlags BarrelGunkFlags;
        public Vector3 TurretPosition;
        public Vector3 BarrelPosition;

        public static TurretClass Read(InstanceDescriptor turr)
        {
            var klass = new TurretClass();

            InstanceDescriptor baseGeometryDescriptor;
            InstanceDescriptor turretGeometryDescriptor;
            InstanceDescriptor barrelGeometryDescriptor;

            using (var reader = turr.OpenRead())
            {
                klass.Name = reader.ReadString(32);
                klass.BaseName = reader.ReadString(32);
                klass.Flags = reader.ReadUInt16();
                klass.FreeTime = reader.ReadUInt16();
                klass.ReloadTime = reader.ReadUInt16();
                klass.BarrelCount = reader.ReadUInt16();
                klass.RecoilAnimType = reader.ReadUInt16();
                klass.ReloadAnimType = reader.ReadUInt16();
                klass.MaxAmmo = reader.ReadUInt16();
                klass.AttachmentCount = reader.ReadUInt16();
                klass.ShooterCount = reader.ReadUInt16();
                reader.Skip(2);
                klass.AimingSpeed = reader.ReadSingle();
                baseGeometryDescriptor = reader.ReadInstance();
                reader.Skip(4);
                klass.BaseGunkFlags = (GunkFlags)reader.ReadInt32();
                turretGeometryDescriptor = reader.ReadInstance();
                klass.TurretGunkFlags = (GunkFlags)reader.ReadInt32();
                barrelGeometryDescriptor = reader.ReadInstance();
                klass.BarrelGunkFlags = (GunkFlags)reader.ReadInt32();
                klass.TurretPosition = reader.ReadVector3();
                klass.BarrelPosition = reader.ReadVector3();
            }

            if (baseGeometryDescriptor != null)
                klass.BaseGeometry = GeometryDatReader.Read(baseGeometryDescriptor);

            if (barrelGeometryDescriptor != null)
                klass.BarrelGeometry = GeometryDatReader.Read(barrelGeometryDescriptor);

            if (turretGeometryDescriptor != null)
                klass.TurretGeometry = GeometryDatReader.Read(turretGeometryDescriptor);

            return klass;
        }

        public override ObjectGeometry[] GunkNodes
        {
            get
            {
                return new[] {
                    new ObjectGeometry {
                        Geometry = BaseGeometry,
                        Flags = BaseGunkFlags
                    }
                };
            }
        }
    }
}
