﻿using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace Oni
{
    internal static class Parallel
    {
        public static void ForEach<T>(IEnumerable<T> items, Action<T> action)
        {
            var array = items.ToArray();

            if (array.Length == 0)
            {
                return;
            }

            if (array.Length == 1)
            {
                action(array[0]);
                return;
            }

            int cpuCount = Environment.ProcessorCount;

            if (cpuCount == 1)
            {
                foreach (T item in array)
                    action(item);

                return;
            }

#if NETCORE
            var task = Task.Run(() =>
            {
                for (int i = array.Length / 2; i < array.Length; i++)
                    action(array[i]);
            });
#else
            var thread = new Thread(() =>
            {
                for (int i = array.Length / 2; i < array.Length; i++)
                    action(array[i]);
            });

            thread.Start();
#endif

            for (int i = 0; i < array.Length / 2; i++)
                action(array[i]);

#if NETCORE
            task.Wait();
#else
            thread.Join();
#endif
        }
    }
}
