﻿using System;
using System.Collections.Generic;

namespace Oni.Particles
{
    internal class Event
    {
        private readonly EventType type;
        private readonly List<EventAction> actions;

        public Event(EventType type)
        {
            this.type = type;
            this.actions = new List<EventAction>();
        }

        public Event(EventType type, EventAction[] actions, int start, int length)
            : this(type)
        {
            for (int i = start; i < start + length; i++)
                this.actions.Add(actions[i]);
        }

        public EventType Type => type;

        public List<EventAction> Actions => actions;
    }
}
