﻿using System;
using System.Collections.Generic;

namespace Oni.Particles
{
    internal class EventAction
    {
        private readonly List<Value> parameters;
        private readonly List<VariableReference> variables;
        private readonly EventActionType type;

        private EventAction()
        {
            this.parameters = new List<Value>();
            this.variables = new List<VariableReference>();
        }

        public EventAction(EventActionType type)
            : this()
        {
            this.type = type;
        }

        public EventAction(BinaryReader reader)
            : this()
        {
            type = (EventActionType)reader.ReadInt32();
            reader.ReadInt32();

            for (int i = 0; i < 8; i++)
            {
                VariableReference value = new VariableReference(reader);

                if (value.IsDefined)
                    variables.Add(value);
            }

            for (int i = 0; i < 8; i++)
            {
                Value value = Value.Read(reader);

                if (value != null)
                    parameters.Add(value);
            }
        }

        public void Write(BinaryWriter writer)
        {
            writer.Write((int)type);
            writer.Write(0);

            foreach (VariableReference variable in variables)
                variable.Write(writer);

            for (int i = variables.Count; i < 8; i++)
                VariableReference.Empty.Write(writer);

            foreach (Value value in parameters)
                value.Write(writer);

            for (int i = parameters.Count; i < 8; i++)
                Value.Empty.Write(writer);
        }

        public EventActionType Type => type;

        public List<Value> Parameters => parameters;

        public List<VariableReference> Variables => variables;
    }
}
