﻿using System;

namespace Oni.Particles
{
    [Flags]
    internal enum ParticleFlags1
    {
        None = 0,

        Decorative = 0x00000001,
        UseSeparateYScale = 0x00000008,

        SpriteMode0 = 0x00000020,
        SpriteMode1 = 0x00000040,
        SpriteMode2 = 0x00000080,

        Geometry = 0x00000100,
        CollideWithWalls = 0x00000200,
        CollideWithChars = 0x00000400,
        ScaleToVelocity = 0x00000800,

        HasVelocity = 0x00001000, // 0x0c, vector3
        HasOrientation = 0x00002000, // 0x24, matrix3x3
        HasPositionOffset = 0x00004000, // 0x0c, vector3
        HasAttachmentMatrix = 0x00008000, // 0x04, pointer to object transform matrix

        HasUnknown = 0x00010000, // 0x10, 
        HasDecalState = 0x00020000, // 0x14
        HasTextureStartTick = 0x00040000, // 0x04
        HasTextureTick = 0x00080000, // 0x04

        HasDamageOwner = 0x00100000, // 0x04,
        HasContrailData = 0x00200000, // 0x20,
        HasLensFlareState = 0x00400000, // 0x04,
        HasAttractor = 0x00800000, // 0x08,

        HasCollisionCache = 0x01000000, // 0x14,

        /// <summary>
        /// SpriteModeMask
        /// </summary>

        SpriteModeMask = 0x000000e0,
    }

    [Flags]
    internal enum ParticleFlags2 : uint
    {
        None = 0,

        UseSpecialTint = 0x00000001,
        DontAttractThroughWalls = 0x00000002,
        ExpireOnCutscene = 0x00000008,

        DieOnCutscene = 0x00000010,
        DisableLevel0 = 0x00000020,
        DisableLevel1 = 0x00000040,

        DrawAsSky = 0x00100000,
        DecalFullBrightness = 0x00200000,
        Decal = 0x00800000,

        InitiallyHidden = 0x01000000,
        Invisible = 0x02000000,
        FadeOutOnEdge = 0x04000000,
        Vector = 0x08000000,

        LockPositionToLink = 0x10000000,
        IsContrailEmitter = 0x20000000,
        LensFlare = 0x40000000,
        OneSidedEdgeFade = 0x80000000,

        /// <summary>
        /// DisableLevelMask
        /// </summary>

        DisableLevelMask = 0x00000060
    }
}
