﻿namespace Oni.Particles
{
    internal class Variable
    {
        private string name;
        private StorageType storageType;
        private Value value;
        private int storageOffset;

        public Variable(string name, StorageType type, Value value)
        {
            this.name = name;
            this.storageType = type;
            this.value = value;
        }

        public Variable(BinaryReader reader)
        {
            name = reader.ReadString(16);
            storageType = (StorageType)reader.ReadInt32();
            storageOffset = reader.ReadInt32();
            value = Value.Read(reader);
        }

        public void Write(BinaryWriter writer)
        {
            writer.Write(name, 16);
            writer.Write((int)storageType);
            writer.Write(0);
            value.Write(writer);
        }

        public string Name => name;

        public StorageType StorageType => storageType;

        public int StorageOffset => storageOffset;

        public Value Value => value;
    }
}
