﻿using System;
using System.Collections.Generic;

namespace Oni.Physics
{
    internal class ObjectAnimation
    {
        public string Name;
        public ObjectAnimationFlags Flags;
        public int Length;
        public int Stop;
        public ObjectAnimationKey[] Keys;

        public List<ObjectAnimationKey> Interpolate()
        {
            var result = new List<ObjectAnimationKey>(Length);

            for (int i = 1; i < Keys.Length; i++)
            {
                var key0 = Keys[i - 1];
                var key1 = Keys[i];

                result.Add(key0);

                for (int j = key0.Time + 1; j < key1.Time; j++)
                {
                    float k = (float)(j - key0.Time) / (key1.Time - key0.Time);

                    result.Add(new ObjectAnimationKey {
                        Time = j,
                        Translation = Vector3.Lerp(key0.Translation, key1.Translation, k),
                        Rotation = Quaternion.Lerp(key0.Rotation, key1.Rotation, k),
                        Scale = Vector3.Lerp(key0.Scale, key1.Scale, k)
                    });
                }
            }

            result.Add(Keys.Last());

            return result;
        }
    }
}
