﻿using System;
using System.Collections.Generic;
using System.IO;

namespace Oni.Physics
{
    internal class ObjectAnimationImporter : Importer
    {
        public ObjectAnimationImporter(string[] args)
        {
        }

        public override void Import(string filePath, string outputDirPath)
        {
            string name = Path.GetFileNameWithoutExtension(filePath);

            if (name.StartsWith("OBAN", StringComparison.Ordinal))
                name = name.Substring(4);

            var scene = Dae.Reader.ReadFile(filePath);

            var importer = new ObjectDaeImporter(null, new Dictionary<string, Akira.AkiraDaeNodeProperties> {
                { scene.Id, new ObjectDaeNodeProperties {
                    HasPhysics = true,
                    Animations = { new ObjectAnimationClip {
                    } }
                } }
            });

            importer.Import(scene);

            BeginImport();

            foreach (var node in importer.Nodes)
            {
                foreach (var anim in node.Animations)
                    ObjectDatWriter.WriteAnimation(anim, this);
            }

            Write(outputDirPath);
        }
    }
}
