﻿using System;

namespace Oni.Physics
{
    internal class ObjectDatWriter
    {
        internal static ImporterDescriptor WriteAnimation(ObjectAnimation animation, Importer importer)
        {
            var frame0 = animation.Keys[0];
            var scaleMatrix = Matrix.CreateScale(frame0.Scale);

            var startMatrix = scaleMatrix
                * Matrix.CreateFromQuaternion(frame0.Rotation)
                * Matrix.CreateTranslation(frame0.Translation);

            var oban = importer.CreateInstance(TemplateTag.OBAN, animation.Name);

            using (var writer = oban.OpenWrite(12))
            {
                writer.Write((int)animation.Flags);
                writer.WriteMatrix4x3(startMatrix);
                writer.WriteMatrix4x3(scaleMatrix);
                writer.WriteInt16(1);
                writer.WriteUInt16(animation.Length);
                writer.WriteInt16(animation.Stop);
                writer.WriteUInt16(animation.Keys.Length);

                foreach (var key in animation.Keys)
                {
                    writer.Write(key.Rotation);
                    writer.Write(key.Translation);
                    writer.Write(key.Time);
                }
            }

            return oban;
        }
    }
}
