﻿using System;
using System.Collections.Generic;

namespace Oni.Physics
{
    internal class ObjectNode
    {
        public string Name;
        public string FileName;
        public ObjectSetupFlags Flags;
        public int ScriptId;
        public readonly ObjectGeometry[] Geometries;
        public readonly ObjectParticle[] Particles;
        public ObjectAnimation[] Animations = new ObjectAnimation[0];

        public ObjectNode(IEnumerable<ObjectGeometry> geometries)
        {
            this.Geometries = geometries.ToArray();
            this.Particles = new ObjectParticle[0];
        }

        public ObjectNode(ObjectGeometry[] geometries, ObjectParticle[] particles)
        {
            this.Geometries = geometries;
            this.Particles = particles;
        }
    }
}
