﻿using System.Xml;
using Oni.Metadata;
using Oni.Xml;

namespace Oni.Physics
{
    internal class ObjectXmlReader
    {
        public static ObjectParticle ReadParticle(XmlReader xml)
        {
            xml.ReadStartElement("Particle");

            var particle = new ObjectParticle
            {
                ParticleClass = xml.ReadElementContentAsString("Class", ""),
                Tag = xml.ReadElementContentAsString("Tag", ""),
                Matrix = xml.ReadElementContentAsMatrix43("Transform"),
                DecalScale = xml.ReadElementContentAsVector2("DecalScale"),
                Flags = xml.ReadElementContentAsEnum<Objects.ParticleFlags>("Flags") & Objects.ParticleFlags.NotInitiallyCreated
            };

            xml.ReadEndElement();

            return particle;
        }
    }
}
