﻿using System;
using System.Xml;
using Oni.Metadata;
using Oni.Xml;

namespace Oni.Sound
{
    internal sealed class OsbdXmlImporter : RawXmlImporter
    {
        public OsbdXmlImporter(XmlReader reader, BinaryWriter writer)
            : base(reader, writer)
        {
        }

        public void Import()
        {
            switch (Xml.LocalName)
            {
                case "AmbientSound":
                    Import(SoundMetadata.OSAm, SoundMetadata.osam6);
                    break;

                case "ImpulseSound":
                    Import(SoundMetadata.OSIm, SoundMetadata.osim6);
                    break;

                case "SoundGroup":
                    Import(SoundMetadata.OSGr, SoundMetadata.osgr6);
                    break;
            }
        }

        private void Import(int tag, MetaStruct type)
        {
            Xml.ReadStartElement();

            BeginStruct(0);

            Writer.Write(tag);
            Writer.Write(0);
            Writer.Write(6);

            ReadStruct(type);
        }
    }
}
