﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Oni.Sound
{
    internal class SoundData
    {
        public int SampleRate;
        public int ChannelCount;
        public byte[] Data;

        public static SoundData Read(InstanceDescriptor sndd)
        {
            if (sndd.Template.Tag != TemplateTag.SNDD)
                throw new ArgumentException("descriptor");

            var sound = new SoundData();

            int dataSize;
            int dataOffset;

            using (var reader = sndd.OpenRead())
            {
                if (sndd.IsMacFile)
                {
                    sound.ChannelCount = (reader.ReadInt32() >> 1) + 1;
                    sound.SampleRate = 22050;
                    reader.Skip(4);
                }
                else
                {
                    reader.Skip(6);
                    sound.ChannelCount = reader.ReadInt16();
                    sound.SampleRate = reader.ReadInt32();
                    reader.Skip(44);
                }

                dataSize = reader.ReadInt32();
                dataOffset = reader.ReadInt32();
            }

            using (var rawReader = sndd.GetRawReader(dataOffset))
                sound.Data = rawReader.ReadBytes(dataSize);

            return sound;
        }
    }
}
