﻿using System;
using System.IO;

namespace Oni.Sound
{
    internal class WavExporter : SoundExporter
    {
        #region Private data
        private const int fcc_RIFF = 0x46464952;
        private const int fcc_WAVE = 0x45564157;
        private const int fcc_fmt = 0x20746d66;
        private const int fcc_data = 0x61746164;

        private static readonly byte[] formatTemplate = new byte[50]
        {
            0x02, 0, 0, 0, 0x22, 0x56, 0, 0, 0, 0, 0, 0, 0, 0x02, 0x04, 0,
            0x20, 0, 0xf4, 0x03, 0x07, 0, 0, 0x01, 0, 0, 0, 0x02, 0, 0xff, 0, 0, 0, 0, 0xc0, 0, 0x40, 0,
            0xf0, 0, 0, 0, 0xcc, 0x01, 0x30, 0xff, 0x88, 0x01, 0x18, 0xff
        };

        #endregion

        public WavExporter(InstanceFileManager fileManager, string outputDirPath)
            : base(fileManager, outputDirPath)
        {
        }

        protected override void ExportInstance(InstanceDescriptor descriptor)
        {
            var sound = SoundData.Read(descriptor);

            using (var stream = File.Create(Path.Combine(OutputDirPath, descriptor.FullName + ".wav")))
            using (var writer = new BinaryWriter(stream))
            {
                var format = (byte[])formatTemplate.Clone();

                Array.Copy(BitConverter.GetBytes(sound.ChannelCount), 0, format, 2, 2);
                Array.Copy(BitConverter.GetBytes(sound.ChannelCount == 1 ? 11155 : 22311), 0, format, 8, 4);
                Array.Copy(BitConverter.GetBytes(sound.ChannelCount == 1 ? 512 : 1024), 0, format, 12, 2);

                writer.Write(fcc_RIFF);
                writer.Write(8 + format.Length + 8 + sound.Data.Length);
                writer.Write(fcc_WAVE);

                //
                // write format chunk
                //

                writer.Write(fcc_fmt);
                writer.Write(format.Length);
                writer.Write(format);

                //
                // write data chunk
                //

                writer.Write(fcc_data);
                writer.Write(sound.Data.Length);
                writer.Write(sound.Data);
            }
        }
    }
}
