using System;
using Oni.Metadata;

namespace Oni
{
    internal sealed class Template
    {
        private readonly TemplateTag tag;
        private readonly string description;
        private readonly MetaStruct type;
        private readonly long checksum;

        internal Template(TemplateTag tag, MetaStruct type, long checksum, string description)
        {
            this.tag = tag;
            this.type = type;
            this.checksum = checksum;
            this.description = description;
        }

        public TemplateTag Tag => tag;
        public MetaStruct Type => type;
        public long Checksum => checksum;
        public string Description => description;
        public bool IsLeaf => type.IsLeaf;
    }
}
