﻿using System;
using System.Collections.Generic;
using System.Globalization;

namespace Oni.Totoro
{
    internal class BodyDaeImporter
    {
        private readonly bool generateNormals;
        private readonly bool flatNormals;
        private readonly float shellOffset;

        public BodyDaeImporter(string[] args)
        {
            foreach (string arg in args)
            {
                if (arg == "-normals")
                {
                    generateNormals = true;
                }
                else if (arg == "-flat")
                {
                    flatNormals = true;
                }
                else if (arg == "-cel" || arg.StartsWith("-cel:", StringComparison.Ordinal))
                {
                    int i = arg.IndexOf(':');

                    if (i != -1)
                        shellOffset = float.Parse(arg.Substring(i + 1), CultureInfo.InvariantCulture);
                    else
                        shellOffset = 0.07f;
                }
            }
        }

        public ImporterDescriptor Import(string filePath, ImporterFile importer)
        {
            var scene = Dae.Reader.ReadFile(filePath);

            Dae.FaceConverter.Triangulate(scene);

            var body = BodyDaeReader.Read(scene, generateNormals, flatNormals, shellOffset);

            return BodyDatWriter.Write(body, importer);
        }
    }
}
