﻿using System;
using Oni.Motoko;

namespace Oni.Totoro
{
    internal class BodyDaeWriter
    {
        private static readonly Vector3[] defaultPose =
        {
            new Vector3(0.0f, 90.0f, 90.0f),

            new Vector3(0.0f, 180.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),

            new Vector3(0.0f, 180.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),

            new Vector3(0.0f, 0.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),

            new Vector3(90.0f, 90.0f, 90.0f),
            new Vector3(0.0f, 90.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),
            new Vector3(-90.0f, 0.0f, 0.0f),

            new Vector3(-90.0f, -90.0f, 90.0f),
            new Vector3(0.0f, -90.0f, 0.0f),
            new Vector3(0.0f, 0.0f, 0.0f),
            new Vector3(90.0f, 0.0f, 0.0f)
        };

        private readonly GeometryDaeWriter geometryWriter;

        public BodyDaeWriter(GeometryDaeWriter geometryWriter)
        {
            this.geometryWriter = geometryWriter;
        }

        public Dae.Node Write(Body body, bool noAnimation, InstanceDescriptor[] textures)
        {
            return WriteNode(body.Root, noAnimation, textures);
        }

        private Dae.Node WriteNode(BodyNode bodyNode, bool useDefaultPose, InstanceDescriptor[] textures)
        {
            if (textures != null)
                bodyNode.Geometry.Texture = textures[bodyNode.Index];

            var daeNode = geometryWriter.WriteNode(bodyNode.Geometry, bodyNode.Name);

            daeNode.Transforms.Translate("pos", bodyNode.Translation);

            if (useDefaultPose)
            {
                var rot = defaultPose[bodyNode.Index];

                daeNode.Transforms.Rotate("rotX", Vector3.Right, rot.X);
                daeNode.Transforms.Rotate("rotY", Vector3.Up, rot.Y);
                daeNode.Transforms.Rotate("rotZ", Vector3.Backward, rot.Z);
            }
            else
            {
                daeNode.Transforms.Rotate("rotX", Vector3.Right, 0.0f);
                daeNode.Transforms.Rotate("rotY", Vector3.Up, 0.0f);
                daeNode.Transforms.Rotate("rotZ", Vector3.Backward, 0.0f);
            }

            foreach (var childBodyNode in bodyNode.Nodes)
                daeNode.Nodes.Add(WriteNode(childBodyNode, useDefaultPose, textures));

            return daeNode;
        }
    }
}
