﻿using System;
using System.IO;

namespace Oni.Totoro
{
    internal class BodySetImporter : Importer
    {
        private BodyDaeImporter bodyImporter;

        public BodySetImporter(string[] args)
        {
            bodyImporter = new BodyDaeImporter(args);
        }

        public override void Import(string filePath, string outputDirPath)
        {
            var name = Path.GetFileNameWithoutExtension(filePath);

            if (name.StartsWith("ONCC", StringComparison.Ordinal))
                name = name.Substring(4);

            BeginImport();

            var trbs = CreateInstance(TemplateTag.TRBS, name);
            var trcm = bodyImporter.Import(filePath, ImporterFile);

            WriteTRBS(trbs, trcm);

            Write(outputDirPath);
        }

        private void WriteTRBS(ImporterDescriptor trbs, ImporterDescriptor trcm)
        {
            using (var writer = trbs.OpenWrite())
            {
                for (int i = 0; i < 5; i++)
                    writer.Write(trcm);
            }
        }
    }
}
