﻿using System;
using System.Collections.Generic;
using System.Xml;
using Oni.Imaging;
using Oni.Metadata;

namespace Oni.Xml
{
    internal class TmbdXmlExporter : RawXmlExporter
    {
        private TmbdXmlExporter(BinaryReader reader, XmlWriter writer)
            : base(reader, writer)
        {
        }

        public static void Export(BinaryReader reader, XmlWriter writer)
        {
            var exporter = new TmbdXmlExporter(reader, writer);
            exporter.Export();
        }

        private void Export()
        {
            int size = Reader.ReadInt32();
            int version = Reader.ReadInt32();
            int count = Reader.ReadInt32();

            var materials = new Dictionary<string, List<string>>(count);

            for (int i = 0; i < count; i++)
            {
                var materialName = Reader.ReadString(32);
                var textureName = Reader.ReadString(32);

                List<string> textures;

                if (!materials.TryGetValue(materialName, out textures))
                {
                    textures = new List<string>();
                    materials.Add(materialName, textures);
                }

                textures.Add(textureName);
            }

            Xml.WriteStartElement("TextureMaterials");

            foreach (var pair in materials)
            {
                Xml.WriteStartElement("Material");
                Xml.WriteAttributeString("Name", pair.Key);

                foreach (var textureName in pair.Value)
                    Xml.WriteElementString("Texture", textureName);

                Xml.WriteEndElement();
            }

            Xml.WriteEndElement();
        }
    }
}
