# Green Room
# A room for playing out moves against a chromakey background
# Recommended viewing size:
# |--------------------------------------------------------------------------|

var int chose_yes = 0;
var int countdown = 10;

func void main(void)
{
   # Set up environment
   sky_show_sky = 0;       # hide skybox
   gs_show_ui = 0;         # do not show UI
   m3_clear_color = 38400; # set background color to green
   #gs_show_particles = 0;  # hide particles
   ui_suppress_prompt = 1; # turn off objective/help prompts

   fork DrawMainMenu();
   fork WatchForYes();
}

# Allow user to choose an anim showcase or just free-run
func void DrawMainMenu(void)
{
   # XXX - also allow third option of fixed camera setup within free-run mode so user can perform his own moves from a fixed vantage point
   dmsg("Welcome to Green Room");
   dmsg("Want to run the animation showcase?");
   dmsg("Press [jump] for 'yes' in the next");
   dmsg("10 seconds. After that, you can");
   dmsg("just free-run...");
   sleep(300);
   countdown = 5;
   fork CountDown();
}

# Count down while user has not made a choice in WatchForYes() yet
func void CountDown(void)
{
   if (countdown eq 5)
      dmsg("5...");
   else if (countdown eq 4)
      dmsg("4...");
   else if (countdown eq 3)
      dmsg("3...");
   else if (countdown eq 2)
      dmsg("2...");
   else if (countdown eq 1)
      dmsg("1...");
   if ((countdown > 0) and (chose_yes eq 0))
   {
      sleep(60);
      countdown = countdown - 1;
      fork CountDown();
   }
   else
   {
      dmsg(" ");
      dmsg(" ");
      dmsg(" ");
      dmsg(" ");
      dmsg(" ");
   }
}

# Allow user to jump to choose to run an anim showcase
func void WatchForYes(void)
{
   chr_wait_animtype(0, jump);
   if ((countdown > 0) and (chose_yes eq 0))
   {
      chose_yes = 1;
      chr_animate(0, KONOKOact_yes1);
      sleep(20);
      DrawShowcaseMenu();
   }
}

# XXX - break this out into functions for the menus described within
func void DrawShowcaseMenu(void)
{
   # XXX - faction menu: pick faction
      # XXX - 1. Konoko
      # XXX - 2. Syndicate
      # XXX - 3. TCTF
      # XXX - 4. Civilian
      # XXX - 5. Exit (free-run mode)

   # XXX - MELE menu: where needed, pick specific MELE ID under above faction -- see "Melee IDs by faction.rtf"; print name of MELE ID once it is selected

   # XXX - character variant menu: allow user to pick exact appearance of char

   # XXX - angle menu: allow user to pick angle to view char from -- at least offer left side and right side, but other options would be front, rear, top, 3/4 left side and 3/4 right side
      # XXX - consider making these choices "checkboxes", i.e. you can choose to see moves from multiple angles, which will play the move successively from each angle

   # XXX - anim type menu: pick type -- attack, victim (hit, thrown, blownup, KOed, etc.), maneuver (dodge, jump, walk, run, crouch-walk, etc.)

   # XXX - variant menu: pick anim variant -- melee, RIF or PIS
 
   # XXX - change room color to a preset value that is suitable for this class, taking into account colors on char and colors of their particle effects

   # XXX - final menu: change color or start
      # XXX - 1. Change Color (leads to color menu)
      # XXX - 2. Run Showcase

   # XXX - color menu (if chosen)
      # XXX - 1. Green
      # XXX - 2. Blue
      # XXX - 3. Black
      # XXX - 4. White
      # XXX - 5. Run Showcase

   PrepKonoko();

   # XXX - call specific RunShowcase_XXX() function
}

# Set up Konoko for the showcase
func void PrepKonoko(void)
{
   # Make Konoko invisible
   chr_mini_me = 1;
   chr_mini_me_amount = 0.0;
   # XXX - pin Konoko so that user input doesn't have a chance of moving the camera or causing a sound effect to play
}

# XXX - make 45 MELE-specific functions named like this, where "ID" = MELE ID
func void RunShowcase_ID(void)
{
   # XXX - spawn chosen char and set focus to them or point camera at their spawn flag
   # XXX - run through all anims for this combination of MELE ID, anim type (the attack / victim / maneuver option) and TRAC variant (COM / PIS / RIF)
      # XXX - note: use table on https://wiki.oni2.net/Combat_moves as reference for TRAM names, etc.
      # XXX - step 1: print each anim name (e.g. "Spinning Suplex"), TRAM name, and the input to trigger the move in-game
      # XXX - step 2: clear this text after one second and play the anim
      # XXX - step 3: wait some time after anim finishes for any particle effects to subside
      # XXX - step 4: move char back to spawn flag and reset their facing
      # XXX - note: put pistol or rifle in hand for PIS/RIF anims
      # XXX - note: spawn dummy for throw anims so char can throw him or be thrown by him
      # XXX - note: knock down char before playing getup anims
}