#define AppId "{{B67333BB-1CF9-4EFD-A40B-E25B5CB4C8A7}}"
#define AppVersion "1.4"
#define AppLongName "Anniversary Edition of Oni"
#define AppShortName "Anniversary-Edition-Setup"

#define MinJavaVersion "1.6"
#define JavaDownloadPage "http://www.java.com/en/download/manual.jsp#win"

[Setup]
AppId={#AppId}
AppVersion={#AppVersion}
AppName={#AppLongName}
DefaultDirName={pf32}\Oni
OutputBaseFilename={#AppShortName}-v{#AppVersion}
DefaultGroupName=Oni AE

DirExistsWarning=no
AppendDefaultDirName=no

CreateUninstallRegKey=no
Uninstallable=no
UsePreviousAppDir=no


ArchitecturesInstallIn64BitMode=x64
ShowComponentSizes=no
AppPublisher=
AppPublisherURL=
AppSupportURL=
AppUpdatesURL=
AllowNoIcons=yes
OutputDir=.
Compression=lzma2/max
SolidCompression=yes

[Languages]
Name: "en"; MessagesFile: "compiler:Default.isl"

[Messages]
en.SelectDirBrowseLabel=Please select the installation directory of Oni.

[CustomMessages]
en.wrongDir=This doesn't seem to be your Oni installation; I don't see a file here named "Oni.exe".
en.JavaNotFound=This program needs a Java Runtime (JRE) with version being at least %1.%nPlease download and install a suitable JRE.%nDo you want do download a JRE now?

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Dirs]
Name: "{app}\AE"; Permissions: users-modify
 
[Files]
Source: "AEInstaller2Updater.jar"; DestDir: "{app}\AE\AEInstaller"
Source: "JRE\*"; DestDir: "{app}\AE\AEInstaller\JRE"; Excludes: ".svn"; Flags: createallsubdirs recursesubdirs onlyifdoesntexist
Source: "AElogo.ico"; DestDir: "{app}\AE\AEInstaller"

[Icons]
Name: "{app}\AE\AEInstaller2"; Filename: "{app}\AE\AEInstaller\JRE\bin\javaw.exe"; WorkingDir: "{app}\AE\AEInstaller"; IconFilename: "{app}\AE\AEInstaller\AElogo.ico"; Parameters: "-Dsun.java2d.d3d=false -jar bin\AEInstaller2.jar"
Name: "{app}\AE\AEInstaller2Updater"; Filename: "{app}\AE\AEInstaller\JRE\bin\javaw.exe"; WorkingDir: "{app}\AE\AEInstaller"; IconFilename: "{app}\AE\AEInstaller\AElogo.ico"; Parameters: "-Dsun.java2d.d3d=false -jar AEInstaller2Updater.jar"
Name: "{group}\AEInstaller 2"; Filename: "{app}\AE\AEInstaller\JRE\bin\javaw.exe"; WorkingDir: "{app}\AE\AEInstaller"; IconFilename: "{app}\AE\AEInstaller\AElogo.ico"; Parameters: "-Dsun.java2d.d3d=false -jar bin\AEInstaller2.jar"
Name: "{commondesktop}\AEInstaller 2"; Filename: "{app}\AE\AEInstaller\JRE\bin\javaw.exe"; WorkingDir: "{app}\AE\AEInstaller"; IconFilename: "{app}\AE\AEInstaller\AElogo.ico"; Parameters: "-Dsun.java2d.d3d=false -jar bin\AEInstaller2.jar"; Tasks: desktopicon

[Run]
Filename: "{app}\AE\AEInstaller\JRE\bin\javaw.exe"; WorkingDir: "{app}\AE\AEInstaller"; Parameters: "-Dsun.java2d.d3d=false -jar AEInstaller2Updater.jar"; Flags: runasoriginaluser; BeforeInstall: WriteProxyData


[Code]
var
  PageUseProxy: TInputOptionWizardPage;
  PageProxyData: TInputQueryWizardPage;


procedure InitializeWizard();
begin
  PageUseProxy := CreateInputOptionPage(wpSelectTasks, 'Internet connection type', '', 'Do you require a proxy to connect to the internet?', true, false);
  PageUseProxy.Add('Direct connection');
  PageUseProxy.Add('Use proxy');
  PageUseProxy.Values[0] := true;

  PageProxyData := CreateInputQueryPage(PageUseProxy.ID, 'Proxy data', '', 'Please enter the data required to connect to your proxy.');
  PageProxyData.Add('Hostname or IP:', False);
  PageProxyData.Add('Port:', False);
end;

function DirOk(Path: String): boolean;
begin
  Result := DirExists(Path+'\GameDataFolder') and FileExists(Path+'\Oni.exe');
end;

function NextButtonClick(CurPageID: Integer): boolean;
begin
  Result := True;

  if CurPageID = wpSelectDir then
  begin
    if (not DirOk(WizardDirValue)) then
    begin
      MsgBox(CustomMessage('wrongDir'), mbError, MB_OK);
      Result := False;
    end;
  end;
end;


function EnterProxyData(): Boolean;
begin
  Result := PageUseProxy.SelectedValueIndex = 1;
end;

function ShouldSkipPage(PageID: Integer): Boolean;
begin
  Result := false;
  if (PageID = PageProxyData.ID) then
    Result := not EnterProxyData();
end;


function UpdateReadyMemo(Space, NewLine, MemoUserInfoInfo, MemoDirInfo, MemoTypeInfo, MemoComponentsInfo, MemoGroupInfo, MemoTasksInfo: String): String;
begin
  Result := MemoUserInfoInfo + NewLine;
  Result := Result + MemoDirInfo + NewLine;
  Result := Result + MemoGroupInfo + NewLine;
  Result := Result + MemoTasksInfo + NewLine;

  if (EnterProxyData()) then
    Result := Result + NewLine + 'Set proxy configuration';
end;


procedure WriteProxyData();
begin
  if (EnterProxyData()) then
  begin
    SaveStringToFile(ExpandConstant('{app}') + '\AE\AEInstaller\AEI-ProxySettings.xml',
        '<?xml version="1.0" ?><Proxy><useProxy>true</useProxy><hostOrIp>'+PageProxyData.Values[0]+'</hostOrIp><port>'+PageProxyData.Values[1]+'</port></Proxy>',
        False);
  end;
end;
