{$A8,B-,C+,D+,E-,F-,G+,H+,I+,J-,K-,L+,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z1}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$IMAGEBASE $00400000}
{$APPTYPE GUI}
{$WARN SYMBOL_DEPRECATED ON}
{$WARN SYMBOL_LIBRARY ON}
{$WARN SYMBOL_PLATFORM ON}
{$WARN SYMBOL_EXPERIMENTAL ON}
{$WARN UNIT_LIBRARY ON}
{$WARN UNIT_PLATFORM ON}
{$WARN UNIT_DEPRECATED ON}
{$WARN UNIT_EXPERIMENTAL ON}
{$WARN HRESULT_COMPAT ON}
{$WARN HIDING_MEMBER ON}
{$WARN HIDDEN_VIRTUAL ON}
{$WARN GARBAGE ON}
{$WARN BOUNDS_ERROR ON}
{$WARN ZERO_NIL_COMPAT ON}
{$WARN STRING_CONST_TRUNCED ON}
{$WARN FOR_LOOP_VAR_VARPAR ON}
{$WARN TYPED_CONST_VARPAR ON}
{$WARN ASG_TO_TYPED_CONST ON}
{$WARN CASE_LABEL_RANGE ON}
{$WARN FOR_VARIABLE ON}
{$WARN CONSTRUCTING_ABSTRACT ON}
{$WARN COMPARISON_FALSE ON}
{$WARN COMPARISON_TRUE ON}
{$WARN COMPARING_SIGNED_UNSIGNED ON}
{$WARN COMBINING_SIGNED_UNSIGNED ON}
{$WARN UNSUPPORTED_CONSTRUCT ON}
{$WARN FILE_OPEN ON}
{$WARN FILE_OPEN_UNITSRC ON}
{$WARN BAD_GLOBAL_SYMBOL ON}
{$WARN DUPLICATE_CTOR_DTOR ON}
{$WARN INVALID_DIRECTIVE ON}
{$WARN PACKAGE_NO_LINK ON}
{$WARN PACKAGED_THREADVAR ON}
{$WARN IMPLICIT_IMPORT ON}
{$WARN HPPEMIT_IGNORED ON}
{$WARN NO_RETVAL ON}
{$WARN USE_BEFORE_DEF ON}
{$WARN FOR_LOOP_VAR_UNDEF ON}
{$WARN UNIT_NAME_MISMATCH ON}
{$WARN NO_CFG_FILE_FOUND ON}
{$WARN IMPLICIT_VARIANTS ON}
{$WARN UNICODE_TO_LOCALE ON}
{$WARN LOCALE_TO_UNICODE ON}
{$WARN IMAGEBASE_MULTIPLE ON}
{$WARN SUSPICIOUS_TYPECAST ON}
{$WARN PRIVATE_PROPACCESSOR ON}
{$WARN UNSAFE_TYPE OFF}
{$WARN UNSAFE_CODE OFF}
{$WARN UNSAFE_CAST OFF}
{$WARN OPTION_TRUNCATED ON}
{$WARN WIDECHAR_REDUCED ON}
{$WARN DUPLICATES_IGNORED ON}
{$WARN UNIT_INIT_SEQ ON}
{$WARN LOCAL_PINVOKE ON}
{$WARN MESSAGE_DIRECTIVE ON}
unit LevelDB;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, StrUtils;

type
  TForm_LevelDB = class(TForm)
    group_progress: TGroupBox;
    progress:     TProgressBar;
    lbl_progress: TLabel;
    btn_abortok:  TButton;
    lbl_estimation: TLabel;
    procedure btn_abortokClick(Sender: TObject);
  private
    procedure HandleFile(Ext: String; FileID: Integer);
    procedure StopConvert;
  public
    procedure CreateDatabase(Source, Target: String);
    procedure CreateLevel(Source, Target: String);
  end;


var
  Form_LevelDB: TForm_LevelDB;

implementation
{$R *.dfm}
uses ABSMain, ABSDecUtil, Main,
    ConnectionManager, TypeDefs, DataAccess, OniImgClass, Data;

type
  THandler = procedure(FileID: Integer);
  TConvertHandler = record
    Ext:     String[4];
    Handler: THandler;
  end;

var
  ConvertHandlers: array of TConvertHandler;
//  loaded_filename: String;
  Converting:  Boolean = False;
  Abort:       Boolean = False;


function GetOpenMsg(msg: TStatusMessages): String;
begin
  case msg of
    SM_AlreadyOpened:    Result := 'File already opened.';
    SM_FileNotFound:     Result := 'File not found.';
    SM_UnknownExtension: Result := 'Unknown extension.';
    SM_IncompatibleFile: Result := 'Incompatible file format.';
    SM_UnknownError:     Result := 'Unknown error.';
  end;
end;


procedure TForm_LevelDB.CreateLevel(Source, Target: String);
var
  DatHeader:        THeader;
  FilesHeader:      TFilesMap;
  NamedFilesHeader: TNamedFilesMap;
  ExtensionsHeader: TExtensionsMap;

  Stream_Body, Stream_Names:          TMemoryStream;
  Stream_Dat, Stream_Raw, Stream_Sep: TFileStream;

//  Data, rawdata: Tdata;
  BeginTime, FileTime: Double;
  Step:     Integer;
//  rawlist:  TRawDataList;
//  datlinks: TDatLinks;
  OniImage:   TOniImage;
  LevelID:    Integer;
  TimeFormat: TFormatSettings;

  ConID:      Integer;
  Connection: TDataAccess;
  ConRepMsg:  TStatusMessages;

  FileID:     Integer;

  Strings:    TStrings;
  i, j:       Integer;
  temps:      String;
  tempi:      Integer;
  tempb:      Byte;
  FileInfo:   TFileInfo;
  DatLinks:   TDatLinkList;
  RawLinks:   TRawDataList;

  DatFileStream, RawFileStream: TMemoryStream;
const
  Steps: Byte = 3;


  procedure DoStep(StepName: String);
  begin
    Inc(Step);
    if StepName <> 'FIN' then
      group_progress.Caption :=
        'Creating Dat (Step ' + IntToStr(Step) + '/' + IntToStr(Steps) + ': ' + StepName + ')'
    else
      group_progress.Caption := 'Creating Dat (FINISHED)';
  end;

begin

  //
  // FILE EXISTS CHECK FR DAT/RAW/SEP!!!
  //

  TimeFormat.ShortTimeFormat := 'hh:nn:ss';
  TimeFormat.LongTimeFormat  := 'hh:nn:ss';
  TimeFormat.TimeSeparator   := ':';

  ConID := ConManager.OpenConnection(Source, ConRepMsg);
  if not (ConRepMsg in [SM_OK, SM_AlreadyOpened]) then
  begin
    ShowMessage('Source-file couldn''t be opened! Aborting' + CrLf + GetOpenMsg(ConRepMsg));
    Exit;
  end else
    Connection := ConManager.Connection[ConID];

  ConID := ConManager.FileOpened(Target);
  if ConID >= 0 then
  begin
    if MessageBox(Self.Handle, PChar('Destination-file is opened, close it in ' +
          'order to proceed conversion?'), PChar('Destination-file opened'),
          MB_YESNO + MB_ICONQUESTION) = ID_YES then
    begin
      if Form_Main.CheckConnectionCloseable(ConID) then
        if not ConManager.CloseConnection(ConID, ConRepMsg) then
        begin
          ShowMessage('Couldn''t close destination-file. Aborting');
          Exit;
        end;
    end else begin
      ShowMessage('Aborting');
      Exit;
    end;
  end;

  if FileExists(Target) then
  begin
    if MessageBox(Self.Handle, PChar('Destination-file exists. ' +
          'Overwrite it?'), PChar('Destination-file exists'),
          MB_YESNO + MB_ICONWARNING) = ID_YES then
    begin
      if not DeleteFile(Target) then
      begin
        ShowMessage('Couldn''t delete file. Aborting');
        Exit;
      end else if not DeleteFile(AnsiReplaceStr(Target, '.dat', '.raw')) then
      begin
        ShowMessage('Couldn''t delete file. Aborting');
        Exit;
      end else if not DeleteFile(AnsiReplaceStr(Target, '.dat', '.sep')) then
      begin
        ShowMessage('Couldn''t delete file. Aborting');
        Exit;
      end;
    end else begin
      ShowMessage('Aborting');
      Exit;
    end;
  end;

  LevelID  := Connection.LevelNumber;
  LevelID  := (LevelID * 2) * 256 * 256 * 256 + $01;
  OniImage := TOniImage.Create;

  Self.Visible := True;
  Form_Main.Visible := False;
  Step := 0;
  Converting := True;
  Abort := False;
  btn_abortok.Caption := '&Abort...';
  btn_abortok.Default := False;
  BeginTime := Time;

  Stream_Body  := TMemoryStream.Create;
  Stream_Names := TMemoryStream.Create;
  Stream_Dat   := TFileStream.Create(Target, fmCreate);
  Stream_Raw   := TFileStream.Create(AnsiReplaceStr(Target, '.dat', '.raw'), fmCreate);
  if Connection.DataOS in [DOS_WINDEMO, DOS_MAC, DOS_MACBETA] then
    Stream_Sep := TFileStream.Create(AnsiReplaceStr(Target, '.dat', '.sep'), fmCreate);

  DoStep('Creating header');
  progress.Position      := 0;
  lbl_progress.Caption   := '';
  lbl_estimation.Caption := 'Estimated finishing time: unknown';
  Application.ProcessMessages;

  SetLength(NamedFilesHeader, 0);
  Strings := TStringList.Create;
  Strings := Connection.GetFilesList('', '', False, ST_ExtNameAsc);
  for i := 0 to Strings.Count - 1 do
  begin
    if MidStr(Strings.Strings[i],
          Pos('-', Strings.Strings[i]) + 1,
          Length(Strings.Strings[i]) -
            Pos('.', ReverseString(Strings.Strings[i])) -
            Pos('-', Strings.Strings[i])
        ) <> '' then
    begin
      SetLength(NamedFilesHeader, Length(NamedFilesHeader) + 1);
      NamedFilesHeader[High(NamedFilesHeader)].FileNumber := StrToInt(MidStr(Strings.Strings[i], 1, 5));
      NamedFilesHeader[High(NamedFilesHeader)].blubb := 0;
    end;
  end;

  for i := 0 to High(DatHeader.OSIdent) do
    case Connection.DataOS of
      DOS_WIN: DatHeader.OSIdent[i] := HeaderOSIdentWin[i];
      DOS_MAC: DatHeader.OSIdent[i] := HeaderOSIdentMac[i];
      DOS_MACBETA: DatHeader.OSIdent[i] := HeaderOSIdentMacBeta[i];
    end;
  for i := 0 to High(DatHeader.GlobalIdent) do
    DatHeader.GlobalIdent[i] := HeaderGlobalIdent[i];
  DatHeader.Files := Connection.GetFileCount;
  DatHeader.NamedFiles := Length(NamedFilesHeader);

  Strings := Connection.GetExtensionsList(EF_ExtCount);

  DatHeader.Extensions := Strings.Count;
  DatHeader.DataAddr   := 0;
  DatHeader.DataSize   := 0;
  DatHeader.NamesAddr  := 0;
  DatHeader.NamesSize  := 0;
  for i := 0 to High(DatHeader.Ident2) do
    DatHeader.Ident2[i] := 0;
  SetLength(FilesHeader, DatHeader.Files);
  SetLength(ExtensionsHeader, DatHeader.Extensions);


  DoStep('Writing extensions-header');
  progress.Max := Strings.Count;
  Application.ProcessMessages;
  for i := 0 to Strings.Count - 1 do
  begin
    temps := Strings.Strings[i];
    ExtensionsHeader[i].ExtCount := StrToInt( MidStr(
            temps,
            Pos('(', temps) + 1,
            Pos(')', temps) - Pos('(', temps) - 1 ) );
    temps := MidStr(temps, 1, 4);
    for j := 0 to 3 do
      ExtensionsHeader[i].Extension[j] := temps[4-j];
    for j := 0 to High(FileTypes) do
      if FileTypes[j].Extension = temps then
        Break;
    if j < Length(FileTypes) then
    begin
      case Connection.DataOS of
        DOS_WIN:     ExtensionsHeader[i].Ident := FileTypes[j].IdentWin;
        DOS_WINDEMO: ExtensionsHeader[i].Ident := FileTypes[j].IdentMac;
        DOS_MAC:     ExtensionsHeader[i].Ident := FileTypes[j].IdentMac;
        DOS_MACBETA: ExtensionsHeader[i].Ident := FileTypes[j].IdentMac;
      end;
    end else begin
      ShowMessage('Unknown Extension: ' + Strings.Strings[i]);
      Exit;
    end;
    progress.Position    := i + 1;
    lbl_progress.Caption := 'Extensions done: ' + IntToStr(i + 1) + '/' +
      IntToStr(Strings.Count);
    Application.ProcessMessages;
  end;

  DoStep('Storing files-data');
  progress.Position := 0;
  progress.Max      := DatHeader.Files;
  lbl_progress.Caption := '';
  lbl_estimation.Caption := 'Estimated finishing time: unknown';
  Application.ProcessMessages;

  FileTime := Time;
  for FileID := 0 to DatHeader.Files - 1 do
  begin
    FileInfo := Connection.GetFileInfo(FileID);
    for j := 0 to 3 do
      FilesHeader[FileID].Extension[j] := FileInfo.Extension[4 - j];
    if FileInfo.Size > 0 then
    begin
      FilesHeader[FileID].DataAddr := Stream_Body.Size + 8;
      DatFileStream := TMemoryStream.Create;
      Connection.LoadDatFile(FileID, TStream(DatFileStream));
      DatFileStream.Seek(4, soFromBeginning);
      DatFileStream.Write(LevelID, 4);

      DatLinks := Connection.GetDatLinks(FileID);
      if Length(DatLinks) > 0 then
      begin
        for i := 0 to High(DatLinks) do
        begin
          DatFileStream.Seek(DatLinks[i].SrcOffset, soFromBeginning);
          if DatLinks[i].DestID < 0 then
            tempi := 0
          else
            tempi := DatLinks[i].DestID * 256 + 1;
          DatFileStream.Write(tempi, 4);
        end;
      end;

      RawLinks := Connection.GetRawList(FileID);
      if Length(RawLinks) > 0 then
      begin
        for i := 0 to High(RawLinks) do
        begin
          if RawLinks[i].RawSize > 0 then
          begin
            RawFileStream := TMemoryStream.Create;
            if UpperCase(fileinfo.Extension) = 'TXMP' then
            begin
              DatFileStream.Seek($88, soFromBeginning);
              DatFileStream.Read(tempb, 1);
              if (tempb and $01) > 0 then
              begin
                OniImage.Load(Connection.ConnectionID, FileID);
                if not OniImage.GetMipMappedImage(TStream(RawFileStream)) then
                begin
                  ShowMessage('MipMapping-Error');
                  RawFileStream.Seek(0, soFromBeginning);
                  tempb := tempb and $FE;
                  DatFileStream.Seek($88, soFromBeginning);
                  DatFileStream.Write(tempb, 1);
                  OniImage.Load(Connection.ConnectionID, FileID);
                  OniImage.GetAsData(TStream(RawFileStream));
                end else
                begin
                  // Change of Depth($89), Storetype ($90)
                  DatFileStream.Seek($89, soFromBeginning);
                  DatFileStream.Read(tempb, 1);

                  DatFileStream.Seek($90, soFromBeginning);
                  DatFileStream.Read(tempb, 1);
                  Exit;
                end;
              end else
                OniImage.GetAsData(TStream(RawFileStream));
            end else begin
              Connection.LoadRawFile(FileID, RawLinks[i].SrcOffset, TStream(RawFileStream));
            end;
            RawFileStream.Seek(0, soFromBeginning);
          end else
            RawLinks[i].RawAddr := 0;
        end;
      end;

{
            if rawlist[j].raw_size > 0 then
            begin
              if (UpperCase(fileinfo.Extension) = 'TXMP') and
                ((Data[$88] and $01) > 0) then
              begin
                OniImage.LoadFromTXMP(Connection, i);
                OniImage.GetMipMappedImage(rawdata);
                rawlist[j].raw_size := OniImage.GetImageDataSize(True);
                Data[$90] := $08;
                Data[$89] := 32;
(*                  if data[$90]<>OniImage.StoreType then begin
                    data[$90]:=OniImage.StoreType;
                    data[$89]:=(data[$89] and $CF) or $20;
                  end;
*)                end
              else
              begin
                SetLength(rawdata, rawlist[j].raw_size);
                OniDataConnection.LoadRawFile(i, rawlist[j].src_offset, @rawdata[0]);
              end;
              //                data[$88]:=data[$88] and $FE;

              if rawlist[j].loc_sep then
              begin
                rawlist[j].raw_addr := Stream_Sep.Size;
                Stream_Sep.Write(rawdata[0], Length(rawdata));
              end
              else
              begin
                rawlist[j].raw_addr := Stream_Raw.Size;
                Stream_Raw.Write(rawdata[0], Length(rawdata));
              end;
            end
            else
              rawlist[j].raw_addr := 0;
            Data[rawlist[j].src_offset + 0] := (rawlist[j].raw_addr) and $FF;
            Data[rawlist[j].src_offset + 1] := (rawlist[j].raw_addr shr 8) and $FF;
            Data[rawlist[j].src_offset + 2] := (rawlist[j].raw_addr shr 16) and $FF;
            Data[rawlist[j].src_offset + 3] := (rawlist[j].raw_addr shr 24) and $FF;
}
      Stream_Body.Write(Data[0], Length(Data));
      //
    end
    else
      FilesHeader[i].DataAddr := 0;
    if Length(fileinfo.Name) > 0 then
    begin
      FilesHeader[i].NameAddr := Stream_Names.Size;
      temps := fileinfo.Extension + fileinfo.Name + Chr(0);
      Stream_Names.Write(temps[1], Length(temps));
    end
    else
      FilesHeader[i].NameAddr := 0;
    FilesHeader[i].FileSize := fileinfo.Size;
    FilesHeader[i].FileType := fileinfo.FileType;

    if ((i mod 10) = 0) and (i >= 100) then
      lbl_estimation.Caption := 'Estimated time left: ' + TimeToStr(
        (Time - FileTime) / i * (progress.Max - i + 1) * 1.1, TimeFormat );
    progress.Position := i + 1;
    lbl_progress.Caption := 'Files done: ' + IntToStr(i + 1) + '/' + IntToStr(progress.Max);
    Application.ProcessMessages;
  end;

  Stream_Dat.Write(DatHeader, SizeOf(DatHeader));
  for i := 0 to High(FilesHeader) do
    Stream_Dat.Write(FilesHeader[i], SizeOf(FilesHeader[i]));
  for i := 0 to High(NamedFilesHeader) do
    Stream_Dat.Write(NamedFilesHeader[i], SizeOf(NamedFilesHeader[i]));
  for i := 0 to High(ExtensionsHeader) do
    Stream_Dat.Write(ExtensionsHeader[i], SizeOf(ExtensionsHeader[i]));

  DatHeader.DataSize  := Stream_Body.Size;
  DatHeader.NamesSize := Stream_Names.Size;
  DatHeader.DataAddr  := Stream_Dat.Size;
  Stream_Body.Seek(0, soFromBeginning);
  Stream_Dat.CopyFrom(Stream_Body, Stream_Body.Size);
  DatHeader.NamesAddr := Stream_Dat.Size;
  Stream_Names.Seek(0, soFromBeginning);
  Stream_Dat.CopyFrom(Stream_Names, Stream_Names.Size);

  Stream_Dat.Seek(0, soFromBeginning);
  Stream_Dat.Write(DatHeader, SizeOf(DatHeader));

  Stream_Dat.Free;
  Stream_Body.Free;
  Stream_Names.Free;
  Stream_Raw.Free;
  if OniDataConnection.OSisMac then
    Stream_Sep.Free;

  progress.Position      := progress.Max;
  lbl_progress.Caption   := 'Files done: ' + IntToStr(progress.Max) + '/' +
    IntToStr(progress.Max);
  lbl_estimation.Caption := 'FINISHED (duration: ' + TimeToStr(Time - Begintime, TimeFormat) + ')';

  DoStep('FIN');
  btn_abortok.Caption := '&OK';
  btn_abortok.Default := True;

  OniImage.Free;

  converting := False;

  CloseDataConnection(DataConnections[conIndex]);
end;




procedure TForm_LevelDB.HandleFile;
var
  i: Byte;
begin
  for i := 1 to Length(ConvertHandlers) do
    if UpperCase(ConvertHandlers[i].Ext) = UpperCase(ext) then
      if ConvertHandlers[i].needed then
      begin
        ConvertHandlers[i].Handler(fileid, dir_dat2db);
        Break;
      end
      else
        Break;
end;




procedure TForm_LevelDB.CreateDatabase(Source, target: String);
var
  DataBase:    TABSDatabase;
  Query:       TABSQuery;
  MimeCoder:   TStringFormat_MIME64;

  i, j:     LongWord;
  temps, temps2: String;
  Data:     Tdata;
  absolutebegintime, begintime: Double;
  step:     Byte;
  rawlist:  TRawList;
  extlist:  TExtensionsMap;
  fileinfo: TFileInfo;
  timeformat: TFormatSettings;

  conIndex: Integer;
const
  steps: Byte = 4;




  procedure DoStep(stepname: String);
  begin
    Inc(step);
    if stepname <> 'FIN' then
      group_progress.Caption :=
        'Creating DB (Step ' + IntToStr(step) + '/' + IntToStr(steps) + ': ' + stepname + ')'
    else
      group_progress.Caption := 'Creating DB (FINISHED)';
  end;

begin
  if CreateDataConnection(Source, ODB_Dat) = nil then
  begin
    ShowMessage('Could not connect to .dat-file');
    Exit;
  end
  else
  begin
    TOniDataDat(OniDataConnection).UnloadWhenUnused := False;
  end;

  timeformat.LongTimeFormat := 'hh:nn:ss';
  timeformat.ShortTimeFormat := 'hh:nn:ss';
  timeformat.TimeSeparator := ':';

  Self.Visible := True;
  Form_Main.Visible := False;
  step  := 0;
  converting := True;
  abort := False;
  btn_abortok.Caption := '&Abort...';
  btn_abortok.Default := False;
  loaded_filename := target;

  absolutebegintime := Time;

  DataBase := TABSDatabase.Create(Self);
  DataBase.DatabaseName := 'OLDB';
  DataBase.DatabaseFileName := target;
  DataBase.CreateDatabase;

  DoStep('Creating tables');
  progress.Position      := 0;
  lbl_progress.Caption   := '';
  lbl_estimation.Caption := 'Estimated finishing time: unknown';
  Application.ProcessMessages;

  Query := TABSQuery.Create(Self);
  Query.DatabaseName := 'OLDB';
  Query.SQL.Text :=
    'CREATE TABLE globals  ( id AUTOINC PRIMARY KEY, name STRING(128), value STRING(128) );';
  Query.ExecSQL;
  Query.SQL.Text :=
    'CREATE TABLE linkmap  ( id AUTOINC PRIMARY KEY, src_id INTEGER, src_link_offset INTEGER, target_id INTEGER );';
  Query.ExecSQL;
  Query.SQL.Text :=
    'CREATE TABLE rawmap  ( id AUTOINC PRIMARY KEY, src_id INTEGER, src_link_offset INTEGER, sep BOOLEAN, size INTEGER, data BLOB BlobCompressionMode 9 BlobBlockSize 1024 BlobCompressionAlgorithm ZLib );';
  //    Query.SQL.Text:='CREATE TABLE rawmap  ( id AUTOINC PRIMARY KEY, src_id INTEGER, src_link_offset INTEGER, size INTEGER, data BLOB BlobCompressionAlgorithm None );';
  Query.ExecSQL;
  Query.SQL.Text :=
    'CREATE TABLE datfiles  ( id INTEGER PRIMARY KEY, extension CHAR(4), name STRING(128), contenttype INTEGER, size INTEGER, data BLOB BlobCompressionMode 9 BlobBlockSize 1024 BlobCompressionAlgorithm ZLib );';
  //    Query.SQL.Text:='CREATE TABLE datfiles  ( id INTEGER PRIMARY KEY, extension CHAR(4), name STRING(128), contenttype INTEGER, size INTEGER, data BLOB BlobCompressionAlgorithm None );';
  Query.ExecSQL;
  Query.SQL.Text :=
    'CREATE TABLE extlist  ( id AUTOINC PRIMARY KEY, ext CHAR(4), ident CHAR(16) );';
  Query.ExecSQL;

  Query.SQL.Text := 'INSERT INTO globals (name,value) VALUES ("dbversion","' +
    dbversion + '");';
  Query.ExecSQL;
  SetLength(Data, Length(OniDataConnection.LevelInfo.Ident));
  for i := 0 to High(OniDataConnection.LevelInfo.Ident) do
    Data[i] := OniDataConnection.LevelInfo.Ident[i];
  temps := CreateHexString(Data, True);
  Query.SQL.Text := 'INSERT INTO globals (name,value) VALUES ("ident","' + temps + '");';
  Query.ExecSQL;
  Query.SQL.Text := 'INSERT INTO globals (name,value) VALUES ("lvl","' +
    IntToStr(OniDataConnection.LevelInfo.LevelNumber) + '");';
  Query.ExecSQL;
  if OniDataConnection.OSisMAC then
    Query.SQL.Text := 'INSERT INTO globals (name,value) VALUES ("os","MAC");'
  else
    Query.SQL.Text := 'INSERT INTO globals (name,value) VALUES ("os","PC");';
  Query.ExecSQL;

  DoStep('Writing extensionslist');
  progress.Max := Length(OniDataConnection.GetExtensionsList);
  Application.ProcessMessages;

  extlist := OniDataConnection.GetExtendedExtensionsList;
  for i := 0 to High(extlist) do
  begin
    SetLength(Data, Length(extlist[i].Ident));
    for j := 0 to High(extlist[i].Ident) do
      Data[j] := extlist[i].Ident[j];
    temps := CreateHexString(Data, True);
    temps2 := extlist[i].Extension[3] + extlist[i].Extension[2] +
      extlist[i].Extension[1] + extlist[i].Extension[0];
    Query.SQL.Text := 'INSERT INTO extlist (ext,ident) VALUES ("' +
      temps2 + '","' + temps + '");';
    Query.ExecSQL;
    progress.Position    := i;
    lbl_progress.Caption := 'Extensions done: ' + IntToStr(i) + '/' +
      IntToStr(Length(extlist));
    Application.ProcessMessages;
    if abort then
    begin
      stop_convert;
      Exit;
    end;
  end;
  lbl_progress.Caption := '';

  progress.Position      := 0;
  lbl_progress.Caption   := 'Files done: ' + IntToStr(0) + '/' + IntToStr(
    OniDataConnection.GetFilesCount);
  lbl_estimation.Caption := 'Estimated finishing time: unknown';

  DoStep('Loading .dat into memory');
  Application.ProcessMessages;

  progress.Max := OniDataConnection.GetFilesCount;
  begintime    := Time;
  DoStep('Writing .dat-fileslist');
  Application.ProcessMessages;

  Database.StartTransaction;
  for i := 0 to OniDataConnection.GetFilesCount - 1 do
  begin
    fileinfo := OniDataConnection.GetFileInfo(i);
    if (fileinfo.FileType and $02) = 0 then
    begin
      mimecoder := TStringFormat_MIME64.Create;
      Data      := OniDataConnection.LoadDatFile(i);
      Query.SQL.Text :=
        'INSERT INTO datfiles (id,extension,name,contenttype,size,data) VALUES (' +
        IntToStr(i) + ',"' + fileinfo.Extension + '","' + fileinfo.Name + '","' + IntToHex(
        fileinfo.FileType, 8) + '",' + IntToStr(fileinfo.Size) + ',MimeToBin("' +
        MimeCoder.StrTo(@Data[0], Length(Data)) + '") );';
      Query.ExecSQL;
      mimecoder.Free;

      rawlist := OniDataConnection.GetRawList(i);
      if Length(rawlist) > 0 then
      begin
        for j := 0 to High(rawlist) do
        begin
          if rawlist[j].raw_size > 0 then
          begin
            SetLength(Data, rawlist[j].raw_size);
            OniDataConnection.LoadRawFile(i, rawlist[j].src_offset, Data);
            mimecoder      := TStringFormat_MIME64.Create;
            Query.SQL.Text :=
              'INSERT INTO rawmap (src_id,src_link_offset,sep,size,data) VALUES (' +
              IntToStr(i) + ',' + IntToStr(rawlist[j].src_offset) + ',' + BoolToStr(
              rawlist[j].loc_sep) + ',' + IntToStr(rawlist[j].raw_size) + ',MimeToBin("' +
              MimeCoder.StrTo(@Data[0], rawlist[j].raw_size) + '") );';
            Query.ExecSQL;
            mimecoder.Free;
          end
          else
          begin
            Query.SQL.Text :=
              'INSERT INTO rawmap (src_id,src_link_offset,sep,size) VALUES (' +
              IntToStr(i) + ',' + IntToStr(rawlist[j].src_offset) + ',' + BoolToStr(rawlist[j].loc_sep) + ',0);';
            Query.ExecSQL;
          end;
        end;
      end;

      HandleFile(fileinfo.Extension, i, True);
    end
    else
    begin
      Query.SQL.Text :=
        'INSERT INTO datfiles (id,extension,name,contenttype,size) VALUES (' +
        IntToStr(i) + ',"' + fileinfo.Extension + '","' + fileinfo.Name + '","' + IntToHex(
        fileinfo.FileType, 8) + '",0);';
      Query.ExecSQL;
    end;
    if ((i mod 100) = 0) and (i > 0) then
    begin
      Database.Commit(False);
      Database.StartTransaction;
    end;
    if ((i mod 10) = 0) and (i >= 100) then
      lbl_estimation.Caption := 'Estimated time left: ' + TimeToStr(
        (Time - begintime) / i * (progress.Max - i + 1) * 1.1, timeformat );
    progress.Position := i;
    lbl_progress.Caption := 'Files done: ' + IntToStr(i) + '/' + IntToStr(progress.Max);
    Application.ProcessMessages;
    if abort then
    begin
      stop_convert;
      Exit;
    end;
  end;
  Database.Commit(False);
  progress.Position      := progress.Max;
  lbl_progress.Caption   := 'Files done: ' + IntToStr(progress.Max) + '/' +
    IntToStr(progress.Max);

  lbl_estimation.Caption := 'FINISHED (duration: ' + TimeToStr(Time - absolutebegintime, timeformat) + ')';

  DoStep('FIN');
  btn_abortok.Caption := '&OK';
  btn_abortok.Default := True;

  converting := False;

  database.Close;
  database.Free;

  CloseDataConnection(DataConnections[conIndex]);
end;




procedure TForm_LevelDB.stop_convert;
begin
  btn_abortok.Caption := '&Close';
  btn_abortok.Default := True;
  converting := False;
  lbl_estimation.Caption := 'ABORTED';
  group_progress.Caption := 'Creating DB (ABORTED)';
  DataBase.Close;
  if MessageBox(Self.Handle, PChar('Delete the unfinished DB-file?'),
    PChar('Delete file?'), MB_YESNO) = idYes then
  begin
    DeleteFile(loaded_filename);
  end;
end;




procedure TForm_LevelDB.btn_abortokClick(Sender: TObject);
begin
  if converting then
  begin
    if MessageBox(Self.Handle,
      PChar('Do you really want to cancel the convert-progress?'),
      PChar('Warning: Converting'), MB_YESNO) = idYes then
      abort := True;
  end
  else
  begin
    Self.Visible := False;
    Form_Main.Visible  := True;
  end;
end;




procedure InsertDatLinkToDB(fileid: LongWord; offset: LongWord);
var
  link: LongWord;
begin
  OniDataConnection.LoadDatFilePart(fileid, offset, 4, @link);
  if link = 0 then
    link := $FFFFFFFF
  else
    link := link div 256;
  Query.SQL.Text := 'INSERT INTO linkmap (src_id,src_link_offset,target_id) VALUES (' +
    IntToStr(fileid) + ',' + IntToStr(offset) + ',' + IntToStr(link) + ');';
  Query.ExecSQL;
end;




procedure AISA(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: Word;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1E, 2, @packages);
    if packages > 0 then
    begin
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * $160 + $28);
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * $160 + $150);
    end;
  end
  else
  begin
  end;
end;




procedure AKEV(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 16 do
      InsertDatLinkToDB(fileid, $8 + i * 4);
  end
  else
  begin
  end;
end;




procedure AKOT(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 4 do
      InsertDatLinkToDB(fileid, $8 + i * 4);
  end
  else
  begin
  end;
end;




procedure CBPI(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 56 do
      InsertDatLinkToDB(fileid, $8 + i * 4);
  end
  else
  begin
  end;
end;




procedure CBPM(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 18 do
      InsertDatLinkToDB(fileid, $8 + i * 4);
  end
  else
  begin
  end;
end;




procedure CONS(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 1 do
      InsertDatLinkToDB(fileid, $24 + i * 4);
  end
  else
  begin
  end;
end;




procedure CRSA(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: LongWord;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $14, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 1100 + $A0);
  end
  else
  begin
  end;
end;




procedure DOOR(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $08);
    InsertDatLinkToDB(fileid, $10);
  end
  else
  begin
  end;
end;




procedure DPGE(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $40);
  end
  else
  begin
  end;
end;




procedure HPGE(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $0C);
  end
  else
  begin
  end;
end;




procedure IGHH(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $24);
    InsertDatLinkToDB(fileid, $28);
  end
  else
  begin
  end;
end;




procedure IGPA(fileid: LongWord; dir_dat2db: Boolean);
var
  links: LongWord;
  i:     LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @links);
    if links > 0 then
      for i := 0 to links - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure IGPG(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 1 do
      InsertDatLinkToDB(fileid, $1C + i * 4);
  end
  else
  begin
  end;
end;




procedure IGSA(fileid: LongWord; dir_dat2db: Boolean);
var
  links: LongWord;
  i:     LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @links);
    if links > 0 then
      for i := 0 to links - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure IMPT(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $10);
  end
  else
  begin
  end;
end;




procedure IPGE(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $0C);
  end
  else
  begin
  end;
end;




procedure KEYI(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 9 do
      InsertDatLinkToDB(fileid, $08 + i * 4);
  end
  else
  begin
  end;
end;




procedure M3GA(fileid: LongWord; dir_dat2db: Boolean);
var
  links: LongWord;
  i:     LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @links);
    if links > 0 then
      for i := 0 to links - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure M3GM(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 6 do
      InsertDatLinkToDB(fileid, $0C + i * 4);
  end
  else
  begin
  end;
end;




procedure MTRL(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $10);
  end
  else
  begin
  end;
end;




procedure OBDC(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: Word;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1E, 2, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * $18 + $4);
  end
  else
  begin
  end;
end;




procedure OBOA(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: Word;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1E, 2, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
      begin
        InsertDatLinkToDB(fileid, $20 + i * 240 + $0);
        InsertDatLinkToDB(fileid, $20 + i * 240 + $4);
        InsertDatLinkToDB(fileid, $20 + i * 240 + $8);
      end;
  end
  else
  begin
  end;
end;




procedure OFGA(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: LongWord;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 12 + $04);
  end
  else
  begin
  end;
end;




procedure ONCC(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $28);
    InsertDatLinkToDB(fileid, $434);
    InsertDatLinkToDB(fileid, $438);
    InsertDatLinkToDB(fileid, $43C);
    InsertDatLinkToDB(fileid, $C3C);
    InsertDatLinkToDB(fileid, $C40);
    InsertDatLinkToDB(fileid, $C44);
    InsertDatLinkToDB(fileid, $C48);
    InsertDatLinkToDB(fileid, $C88);
    InsertDatLinkToDB(fileid, $C8C);
  end
  else
  begin
  end;
end;




procedure ONCV(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $08);
  end
  else
  begin
  end;
end;




procedure ONLV(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 5 do
      InsertDatLinkToDB(fileid, $48 + i * 4);
    for i := 0 to 5 do
      InsertDatLinkToDB(fileid, $64 + i * 4);
    InsertDatLinkToDB(fileid, $300);
  end
  else
  begin
  end;
end;




procedure ONOA(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: LongWord;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 8 + $04);
  end
  else
  begin
  end;
end;




procedure ONSK(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $08);
    InsertDatLinkToDB(fileid, $0C);
    InsertDatLinkToDB(fileid, $10);
    InsertDatLinkToDB(fileid, $14);
    InsertDatLinkToDB(fileid, $18);
    InsertDatLinkToDB(fileid, $20);
    InsertDatLinkToDB(fileid, $44);
  end
  else
  begin
  end;
end;




procedure ONVL(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: LongWord;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure ONWC(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $28);
    InsertDatLinkToDB(fileid, $34);
    InsertDatLinkToDB(fileid, $40);
    InsertDatLinkToDB(fileid, $54);
    InsertDatLinkToDB(fileid, $58);
    InsertDatLinkToDB(fileid, $5C);
    InsertDatLinkToDB(fileid, $60);
    InsertDatLinkToDB(fileid, $6FC);
    InsertDatLinkToDB(fileid, $700);
  end
  else
  begin
  end;
end;




procedure OPGE(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $0C);
  end
  else
  begin
  end;
end;




procedure PSPC(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $50);
  end
  else
  begin
  end;
end;




procedure PSPL(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: LongWord;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 8 + $4);
  end
  else
  begin
  end;
end;




procedure PSUI(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 43 do
      InsertDatLinkToDB(fileid, $08 + i * 4);
  end
  else
  begin
  end;
end;




procedure STNA(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: Word;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1E, 2, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure TRAC(fileid: LongWord; dir_dat2db: Boolean);
var
  packages: Word;
  i: LongWord;
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $18);
    OniDataConnection.LoadDatFilePart(fileid, $1E, 2, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 12 + 8);
  end
  else
  begin
  end;
end;




procedure TRAM(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $40);
    InsertDatLinkToDB(fileid, $44);
  end
  else
  begin
  end;
end;




procedure TRAS(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $08);
  end
  else
  begin
  end;
end;




procedure TRBS(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 4 do
      InsertDatLinkToDB(fileid, $08 + i * 4);
  end
  else
  begin
  end;
end;




procedure TRCM(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
begin
  if dir_dat2db then
  begin
    for i := 0 to 2 do
      InsertDatLinkToDB(fileid, $5C + i * 4);
  end
  else
  begin
  end;
end;




procedure TRGA(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: Word;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1E, 2, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure TRGE(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $20);
  end
  else
  begin
  end;
end;




procedure TRIG(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $18);
    InsertDatLinkToDB(fileid, $24);
    InsertDatLinkToDB(fileid, $28);
  end
  else
  begin
  end;
end;




procedure TRMA(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: Word;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1E, 2, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure TRSC(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: Word;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1E, 2, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure TSFF(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure TSFT(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $1C);
  end
  else
  begin
  end;
end;




procedure TURR(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $60);
    InsertDatLinkToDB(fileid, $6C);
    InsertDatLinkToDB(fileid, $74);
  end
  else
  begin
  end;
end;




procedure TXAN(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure TXMA(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure TXMB(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure TXMP(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $94);
    InsertDatLinkToDB(fileid, $98);
  end
  else
  begin
  end;
end;




procedure TXTC(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $08);
  end
  else
  begin
  end;
end;




procedure WMCL(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 8 + $4);
  end
  else
  begin
  end;
end;




procedure WMDD(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $11C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $120 + i * $124 + $114);
  end
  else
  begin
  end;
end;




procedure WMMB(fileid: LongWord; dir_dat2db: Boolean);
var
  i: LongWord;
  packages: LongWord;
begin
  if dir_dat2db then
  begin
    OniDataConnection.LoadDatFilePart(fileid, $1C, 4, @packages);
    if packages > 0 then
      for i := 0 to packages - 1 do
        InsertDatLinkToDB(fileid, $20 + i * 4);
  end
  else
  begin
  end;
end;




procedure WPGE(fileid: LongWord; dir_dat2db: Boolean);
begin
  if dir_dat2db then
  begin
    InsertDatLinkToDB(fileid, $08);
    InsertDatLinkToDB(fileid, $0C);
  end
  else
  begin
  end;
end;




procedure InsertHandler(ext: String; needed: Boolean; handler: THandler);
begin
  SetLength(ConvertHandlers, Length(ConvertHandlers) + 1);
  ConvertHandlers[High(ConvertHandlers)].Ext     := ext;
  ConvertHandlers[High(ConvertHandlers)].needed  := needed;
  ConvertHandlers[High(ConvertHandlers)].handler := handler;
end;

begin
  InsertHandler('ABNA', False, nil);
  //  InsertHandler('AGDB',True,AGDB);
  InsertHandler('AGDB', False, nil);
  InsertHandler('AGQC', False, nil);
  InsertHandler('AGQG', False, nil);
  InsertHandler('AGQR', False, nil);
  InsertHandler('AISA', True, AISA);
  InsertHandler('AITR', False, nil);
  InsertHandler('AKAA', False, nil);
  InsertHandler('AKBA', False, nil);
  InsertHandler('AKBP', False, nil);
  InsertHandler('AKDA', False, nil);
  InsertHandler('AKEV', True, AKEV);
  InsertHandler('AKOT', True, AKOT);
  InsertHandler('AKVA', False, nil);
  InsertHandler('BINA', False, nil);
  InsertHandler('CBPI', True, CBPI);
  InsertHandler('CBPM', True, CBPM);
  InsertHandler('CONS', True, CONS);
  InsertHandler('CRSA', True, CRSA);
  InsertHandler('DOOR', True, DOOR);
  InsertHandler('DPGE', True, DPGE);
  InsertHandler('ENVP', False, nil);
  InsertHandler('FILM', False, nil);
  InsertHandler('HPGE', True, HPGE);
  InsertHandler('IDXA', False, nil);
  InsertHandler('IGHH', True, IGHH);
  InsertHandler('IGPA', True, IGPA);
  InsertHandler('IGPG', True, IGPG);
  InsertHandler('IGSA', True, IGSA);
  InsertHandler('IMPT', True, IMPT);
  InsertHandler('IPGE', True, IPGE);
  InsertHandler('KEYI', True, KEYI);
  InsertHandler('M3GA', True, M3GA);
  InsertHandler('M3GM', True, M3GM);
  InsertHandler('MTRL', True, MTRL);
  InsertHandler('OBAN', False, nil);
  InsertHandler('OBDC', True, OBDC);
  InsertHandler('OBOA', True, OBOA);
  InsertHandler('OFGA', True, OFGA);
  InsertHandler('ONCC', True, ONCC);
  InsertHandler('ONCP', False, nil);
  InsertHandler('ONCV', True, ONCV);
  InsertHandler('ONFA', False, nil);
  InsertHandler('ONGS', False, nil);
  InsertHandler('ONIA', False, nil);
  InsertHandler('ONLD', False, nil);
  InsertHandler('ONLV', True, ONLV);
  InsertHandler('ONMA', False, nil);
  InsertHandler('ONOA', True, ONOA);
  InsertHandler('ONSA', False, nil);
  InsertHandler('ONSK', True, ONSK);
  InsertHandler('ONTA', False, nil);
  InsertHandler('ONVL', True, ONVL);
  InsertHandler('ONWC', True, ONWC);
  InsertHandler('OPGE', True, OPGE);
  InsertHandler('OSBD', False, nil);
  InsertHandler('OTIT', False, nil);
  InsertHandler('OTLF', False, nil);
  InsertHandler('PLEA', False, nil);
  InsertHandler('PNTA', False, nil);
  InsertHandler('PSPC', True, PSPC);
  InsertHandler('PSPL', True, PSPL);
  InsertHandler('PSUI', True, PSUI);
  InsertHandler('QTNA', False, nil);
  InsertHandler('SNDD', False, nil);
  InsertHandler('STNA', True, STNA);
  InsertHandler('SUBT', False, nil);
  InsertHandler('TRAC', True, TRAC);
  InsertHandler('TRAM', True, TRAM);
  InsertHandler('TRAS', True, TRAS);
  InsertHandler('TRBS', True, TRBS);
  InsertHandler('TRCM', True, TRCM);
  InsertHandler('TRGA', True, TRGA);
  InsertHandler('TRGE', True, TRGE);
  InsertHandler('TRIA', False, nil);
  InsertHandler('TRIG', True, TRIG);
  InsertHandler('TRMA', True, TRMA);
  InsertHandler('TRSC', True, TRSC);
  InsertHandler('TRTA', False, nil);
  InsertHandler('TSFF', True, TSFF);
  InsertHandler('TSFL', False, nil);
  InsertHandler('TSFT', True, TSFT);
  InsertHandler('TSGA', False, nil);
  InsertHandler('TSTR', False, nil);
  InsertHandler('TURR', True, TURR);
  InsertHandler('TXAN', True, TXAN);
  InsertHandler('TXCA', False, nil);
  InsertHandler('TXMA', True, TXMA);
  InsertHandler('TXMB', True, TXMB);
  InsertHandler('TXMP', True, TXMP);
  InsertHandler('TXTC', True, TXTC);
  InsertHandler('VCRA', False, nil);
  InsertHandler('WMCL', True, WMCL);
  InsertHandler('WMDD', True, WMDD);
  InsertHandler('WMM_', False, nil);
  InsertHandler('WMMB', True, WMMB);
  InsertHandler('WPGE', True, WPGE);
end.
