unit MetaEditor;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, VirtualTrees, _FileManager;

type
  TForm_Meta = class(TForm)
    VST: TVirtualStringTree;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure VSTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; TextType: TVSTTextType; var CellText: WideString);
  private
  public
    FileManager: TFileManager;
  end;

var
  Form_Meta: TForm_Meta;

implementation
uses
  Data, _DataTypes, _FileTypes;
{$R *.dfm}

type
  PNodeData = ^TNodeData;

  TNodeData = record
    Field: TObject;
  end;

function AddVSTEntry(AVST: TCustomVirtualStringTree; ANode: PVirtualNode;
  ARecord: TNodeData): PVirtualNode;
var
  Data: PNodeData;
begin
  Result := AVST.AddChild(ANode);
  Data   := AVST.GetNodeData(Result);
  AVST.ValidateNode(Result, False);
  Data^ := ARecord;
end;



procedure TForm_Meta.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FileManager.Free;
  Action := caFree;
end;


procedure TForm_Meta.FormCreate(Sender: TObject);
var
  a,b,c: Int64;
  i: Integer;
  data: TNodeData;
begin
  VST.NodeDataSize := SizeOf(TNodeData);
  VST.Font.Charset := AppSettings.CharSet;
  VST.Clear;

  QueryPerformanceFrequency(c);
  QueryPerformanceCounter(a);
  FileManager := TFileManager.Create(1);
  QueryPerformanceCounter(b);
  ShowMessage('Loading Done - ' + FloatToStr((b-a)/c) + 's');

  for i := 0 to FileManager.FileCount - 1 do
  begin
    data.Field := FileManager.FileById[i];
    AddVSTEntry(VST, nil, data);
  end;
end;



procedure TForm_Meta.VSTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
  Column: TColumnIndex; TextType: TVSTTextType; var CellText: WideString);
var
  Data: PNodeData;
begin
  Data     := Sender.GetNodeData(Node);
  CellText := '';
  if TextType = ttNormal then
  begin
    case Column of
      0: begin
        if Data.Field is TFile then
        begin
          CellText := TFile(Data.Field).FileName;
        end;
      end;
{      0:
        CellText := Data.Caption;
      1:
        if Data.DataType > 0 then
          CellText := '0x' + IntToHex(Data.Offset, 8)
        else if Data.Offset > 0 then
          CellText := '0x' + IntToHex(Data.Offset, 8);
      2:
        if Data.DataType > 0 then
          CellText := GetDataType(Data.DataType);
      3:
        if Data.DataType > 0 then
          CellText := Data.Value //GetValue(data.DataType, data.Offset)
        else if Length(Data.Value) > 0 then
          CellText := IntToStr(StrToInt(Data.Value)) + ' Bytes';
      4:
        CellText := Data.Description;
}    end;
  end;
end;

{

procedure WriteStructureInfos;
var
  i, j:    Integer;
  pdata:   PNodeData;
  Data:    TNodeData;
  node:    PVirtualNode;
begin
  VST.BeginUpdate;
  if VST.RootNodeCount = 0 then
  begin
    structs := LoadStructureDefinition(ConID, fileid);
    if structs.Data then
    begin
      if Length(structs.Global) > 0 then
      begin
        for i := 0 to High(structs.Global) do
        begin
          Data.Caption  := structs.Global[i].Name;
          Data.Offset   := structs.Global[i].offset;
          Data.DataType := structs.Global[i].datatype;
          Data.Value    := GetValue(structs.Global[i].datatype, structs.Global[i].offset);
          Data.Description := structs.Global[i].description;
          AddVSTEntry(VST, nil, Data);
        end;
      end;
      if Length(structs.Subs) > 0 then
      begin
        for i := 0 to High(structs.Subs) do
        begin
          with structs.Subs[i] do
          begin
            if Length(Entries) > 0 then
            begin
              if Pos('#', SubName) > 0 then
              begin
                Data.Offset  := StrToInt('$'+MidStr(SubName, Pos('#', SubName) + 1, 8));
                Data.Value   := '$' +
                  MidStr(SubName, PosEx('#', SubName, Pos('#', SubName) + 1) + 1, 8);
                Data.Caption := MidStr(SubName, 1, Pos('#', SubName) - 1);
                Data.Description := SubDesc;
              end
              else
              begin
                Data.Caption := SubName;
                Data.Description := SubDesc;
                Data.Offset := 0;
                Data.Value := '';
              end;
              Data.DataType := 0;
              node := AddVSTEntry(VST, nil, Data);
              Data.Description := '';
              for j := 0 to High(Entries) do
              begin
                Data.Caption  := Entries[j].Name;
                Data.Offset   := Entries[j].offset;
                Data.DataType := Entries[j].datatype;
                Data.Value    := GetValue(Entries[j].datatype, Entries[j].offset);
                Data.Description := Entries[j].description;
                AddVSTEntry(VST, node, Data);
              end;
            end;
          end;
        end;
      end;
    end;
    if VST.RootNodeCount > 0 then
      VST.FocusedNode := VST.GetFirst;
  end
  else
  begin
    Node := VST.GetFirst;
    while Assigned(Node) do
    begin
      pdata := VST.GetNodeData(Node);
      if pdata.DataType > 0 then
        pdata.Value := GetValue(pdata.Datatype, pdata.Offset);
      Node := VST.GetNext(Node);
    end;
  end;
  VST.EndUpdate;
end;
}
end.
