unit _BaseTemplate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, StrUtils,
  TypeDefs;

type
  TNewConnectionEvent = procedure(ConnectionID: Integer) of object;
  TCheckCloseableEvent = function: Boolean of object;

  TForm_BaseTemplate = class(TForm)
    panel_connection: TPanel;
    label_connection: TLabel;
    combo_connection: TComboBox;
    panel_basecontent: TPanel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure combo_connectionChange(Sender: TObject);
  protected
    FOnNewConnection: TNewConnectionEvent;
    FOnCheckCloseable: TCheckCloseableEvent;
    FConnectionID: Integer;
    function GetToolCloseable: Boolean;
  public
    constructor Create(AOwner: TComponent); override;
    procedure UpdateConList;
    procedure SelectConnection(ConnectionID: Integer);
  published
    property OnNewConnection: TNewConnectionEvent read FOnNewConnection write FOnNewConnection;
    property OnCheckCloseable: TCheckCloseableEvent read FOnCheckCloseable write FOnCheckCloseable;
    property ConnectionID: Integer read FConnectionID;
    property Closeable: Boolean read GetToolCloseable;
  end;

  
implementation
{$R *.dfm}
uses Main, ConnectionManager;


procedure TForm_BaseTemplate.UpdateConList;
var
  i: Integer;
  fn, datatype, boxstring: String;
  level: Integer;
begin
  combo_connection.ItemIndex := -1;
  combo_connection.Items.Clear;
  if ConManager.Count > 0 then
  begin
    for i := 0 to ConManager.Count - 1 do
    begin
      level := ConManager.ConnectionByIndex[i].LevelNumber;
      fn := ExtractFileName(ConManager.ConnectionByIndex[i].FileName);
      if ConManager.ConnectionByIndex[i].Backend = DB_ONI then
        datatype := 'ONI-.dat: '
      else if ConManager.ConnectionByIndex[i].Backend = DB_ADB then
        datatype := 'OUP-DB: '
      else
        datatype := 'Unknown: ';
      boxstring := datatype + fn + ' (Level: ' + IntToStr(level) + ') [' + IntToStr(ConManager.ConnectionByIndex[i].ConnectionID) + ']';
      combo_connection.Items.Add(boxstring);
      if ConManager.ConnectionByIndex[i].ConnectionID = FConnectionID then
        combo_connection.ItemIndex := combo_connection.Items.Count - 1;
    end;
    if combo_connection.ItemIndex = -1 then
    begin
      combo_connection.ItemIndex := 0;
      combo_connectionChange(Self);
    end;
  end
  else
  begin
    FConnectionID := 0;
    combo_connectionChange(Self);
  end;
end;



procedure TForm_BaseTemplate.combo_connectionChange(Sender: TObject);
var
  name: String;
begin
  if combo_connection.ItemIndex >= 0 then
  begin
    name := combo_connection.Items.Strings[combo_connection.ItemIndex];
    FConnectionID := StrToInt(MidStr(name, Pos('[', name) + 1, Pos(']', name) - Pos('[', name)  - 1));
  end
  else
    FConnectionID := -1;
  if Assigned(FOnNewConnection) then
    FOnNewConnection(FConnectionID);
end;


procedure TForm_BaseTemplate.SelectConnection(ConnectionID: Integer);
begin
  if FConnectionID <> ConnectionID then
  begin
    combo_connection.ItemIndex := ConManager.ConnectionIndexByID[ConnectionID];
    combo_connectionChange(Self);
  end;
end;


function TForm_BaseTemplate.GetToolCloseable: Boolean;
begin
  if Assigned(FOnCheckCloseable) then
    Result := FOnCheckCloseable
  else
    Result := True;
end;


constructor TForm_BaseTemplate.Create(AOwner: TComponent);
begin
  inherited;
  Self.Width  := 260;
  Self.Height := 300;
  FOnNewConnection := nil;
  FOnCheckCloseable := nil;
  FConnectionID := -1;
  UpdateConList;
end;

procedure TForm_BaseTemplate.FormActivate(Sender: TObject);
begin
  if panel_basecontent.CanFocus then
    panel_basecontent.SetFocus;
end;

procedure TForm_BaseTemplate.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;


end.