unit Extractor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, _TemplateFileList, Menus, StdCtrls, ExtCtrls, Buttons, ComCtrls;

type
  TForm_Extractor = class(TForm_TemplateFileList)
    group_extract: TGroupBox;
    label_export_sel: TLabel;
    label_path: TLabel;
    check_dat: TCheckBox;
    check_raw: TCheckBox;
    check_convert: TCheckBox;
    radio_selected: TRadioButton;
    radio_all: TRadioButton;
    edit_path: TEdit;
    btn_path: TButton;
    btn_export: TButton;
    group_progress: TGroupBox;
    lbl_progress: TLabel;
    lbl_estimated: TLabel;
    progress: TProgressBar;
    btn_abort: TButton;
    procedure btn_abortClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btn_exportClick(Sender: TObject);
    procedure btn_pathClick(Sender: TObject);
  private
  public
  end;


implementation
{$R *.dfm}
uses
  Data, FolderBrowser, Exporters, _TemplateFile, ConnectionManager, Functions,
  StrUtils;



procedure TForm_Extractor.btn_abortClick(Sender: TObject);
begin
  ShowMessage('X');
end;

procedure TForm_Extractor.btn_exportClick(Sender: TObject);
var
  begintime: Double;
  files:     Integer;
  i, done:   Integer;
  selonly:   Boolean;
  fileid:    Integer;
  filename:  String;
  path:      String;
begin
  inherited;
  panel_files.Enabled := False;
  group_extract.Enabled := False;
  group_progress.Visible := True;

  path := edit_path.Text;
  if not EndsText('\', path) then
    path := path + '\';

  begintime := Time;
  lbl_estimated.Caption := 'Estimated finishing time: unknown';
  progress.Position := 0;

  selonly := radio_selected.Checked;

  if selonly then
    files := filelist.SelCount
  else
    files := filelist.Count;

  lbl_progress.Caption := 'Files done: 0/' + IntToStr(files);
  progress.Max := files;
  done  := 0;

  for i := 0 to filelist.Count - 1 do
  begin
    if (selonly and filelist.Selected[i]) or not selonly then
    begin
      fileid := ConManager.Connection[ConnectionID].ExtractFileIDOfName(filelist.Items.Strings[i]);
      filename := GetWinFilename(filelist.Items.Strings[i]);
      if check_dat.Checked then
        ExportDatFile(ConnectionID, fileid, path + filename);
      if check_raw.Checked then
        ExportRawFiles(ConnectionID, fileid, path + filename);
      if check_convert.Checked then
        ExportConverted(ConnectionID, fileid, path + filename);
      Inc(done);
    end;
    if ((done mod 10) = 0) and (done >= 50) then
      lbl_estimated.Caption := 'Estimated finishing time: ' + TimeToStr(
            (Time - begintime) / done * files + begintime);

    progress.Position    := done;
    lbl_progress.Caption := 'Files done: ' + IntToStr(done) + '/' + IntToStr(files);
    Application.ProcessMessages;
  end;

  panel_files.Enabled := True;
  group_extract.Enabled := True;
  group_progress.Visible := False;
end;

procedure TForm_Extractor.btn_pathClick(Sender: TObject);
var
  fb: TFolderBrowser;
begin
  inherited;

  fb := TFolderBrowser.Create(Handle, 'Please select a folder where you want ' +
        'the files to be stored...', edit_path.Text, False, True);
  if fb.Execute then
  begin
    edit_path.Text := fb.SelectedItem;
    AppSettings.ExtractPath := edit_path.Text;
  end;
  fb.Free;
end;

procedure TForm_Extractor.FormCreate(Sender: TObject);
begin
  inherited;
  Self.AllowMultiSelect := True;
  edit_path.Text := AppSettings.ExtractPath;
end;

begin
  AddToolListEntry('extractor', 'Extractor', '');
end.

