UNIT Unit7_txmpreplace;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, StrUtils, Unit2_functions, Unit3_data;

TYPE
  TForm7 = Class(TForm)
    panel_12: TPanel;
    group_txmpselect: TGroupBox;
    splitter_txmp: TSplitter;
    list_txmp: TListBox;
    Splitter1: TSplitter;
    group_bmpselect: TGroupBox;
    panel_load: TPanel;
    btn_load: TButton;
    image_bmppreview: TImage;
    opend: TOpenDialog;
    group_options: TGroupBox;
    btn_replace: TButton;
    check_transparency: TCheckBox;
    check_fading: TCheckBox;
    check_32bit: TCheckBox;
    panel_txmppreview: TPanel;
    btn_save: TButton;
    image_txmppreview: TImage;
    saved: TSaveDialog;
    PROCEDURE btn_saveClick(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    PROCEDURE btn_replaceClick(Sender: TObject);
    PROCEDURE btn_loadClick(Sender: TObject);
    PROCEDURE list_txmpClick(Sender: TObject);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE Recreatelist;
  PRIVATE
  PUBLIC
  END;

VAR
  Form7: TForm7;

IMPLEMENTATION
USES Unit1_main, Unit6_imgfuncs;
{$R *.dfm}
VAR
  actual_bmpdata:Tdata;

PROCEDURE TForm7.Recreatelist;
  VAR
    files:TStringList;
    i:LongWord;
  BEGIN
    list_txmp.Items.Clear;
    files:=GetFilesList('TXMP','',True);
    IF Length(files)>0 THEN
      FOR i:=0 TO High(files) DO
        list_txmp.Items.Add(files[i]);
    group_bmpselect.Enabled:=False;
    check_transparency.Checked:=False;
    check_fading.Checked:=False;
  END;

  
PROCEDURE TForm7.FormResize(Sender: TObject);
  BEGIN
    IF Self.Width>=400 THEN BEGIN
    END ELSE Self.Width:=400;
    IF Self.Height>=350 THEN BEGIN
    END ELSE Self.Height:=350;
  END;

PROCEDURE TForm7.list_txmpClick(Sender: TObject);
  VAR
    id:LongWord;
    data:Tdata;
    img:TImgPackage;
    mem:TMemoryStream;
    fadingbyte,depthbyte,storebyte:Byte;
  BEGIN
    id:=StrToInt(MidStr(list_txmp.Items.Strings[list_txmp.ItemIndex],1,5));

    LoadDatFilePart(id,$88,SizeOf(fadingbyte),@fadingbyte);
    LoadDatFilePart(id,$89,SizeOf(depthbyte),@depthbyte);
    LoadDatFilePart(id,$90,SizeOf(storebyte),@storebyte);
    check_fading.Checked:=(fadingbyte AND $01)>0;
    check_transparency.Checked:=(depthbyte AND $04)>0;
    check_32bit.Checked:=(storebyte=8);

    img:=LoadImgData(id);
    data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);

    mem:=TMemoryStream.Create;
    mem.Write(data[0],Length(data));
    mem.Seek(0,soFromBeginning);
    image_txmppreview.Picture.Bitmap.LoadFromStream(mem);
    mem.Free;

    group_bmpselect.Enabled:=True;
  END;

PROCEDURE TForm7.btn_loadClick(Sender: TObject);
  VAR
    bmpfile:TFileStream;
    mem:TMemoryStream;
  BEGIN
    IF opend.Execute THEN BEGIN
      bmpfile:=TFileStream.Create(opend.FileName, fmOpenRead);
      SetLength(actual_bmpdata,bmpfile.Size);
      bmpfile.Read(actual_bmpdata[0],bmpfile.Size);
      bmpfile.Free;

      mem:=TMemoryStream.Create;
      mem.Write(actual_bmpdata[0],Length(actual_bmpdata));
      mem.Seek(0,soFromBeginning);
      image_bmppreview.Picture.Bitmap.LoadFromStream(mem);
      mem.Free;

      group_options.Enabled:=True;
    END;
  END;

PROCEDURE TForm7.btn_replaceClick(Sender: TObject);
  VAR
    id:LongWord;
    imgpkg:TImgPackage;
    rawfile:TFileStream;
    dataddr:LongWord;
    old_rawaddr,new_rawaddr:LongWord;
    oldwidth,oldheight:Word;
    oldstore,olddepth,oldfading:Byte;
    oldsize:LongWord;
    newsize:LongWord;
    datbyte:Word;
  BEGIN
    IF list_txmp.ItemIndex>=0 THEN BEGIN
      imgpkg:=BmpToImgdata(actual_bmpdata,check_32bit.Checked);

      id:=StrToInt(MidStr(list_txmp.Items.Strings[list_txmp.ItemIndex],1,5));
      LoadDatFilePart(id,$8C,2,@oldwidth);
      LoadDatFilePart(id,$8E,2,@oldheight);
      LoadDatFilePart(id,$88,1,@oldfading);
      LoadDatFilePart(id,$89,1,@olddepth);
      LoadDatFilePart(id,$90,1,@oldstore);
      LoadDatFilePart(id,$9C,4,@old_rawaddr);
      IF (oldwidth<>imgpkg.imgx) OR (oldheight<>imgpkg.imgy) THEN BEGIN
        IF MessageBox(Self.Handle,
                    PChar('Current image and new image have different size'+CrLf+
                            '(Current: '+IntToStr(oldwidth)+'x'+IntToStr(oldheight)+
                            ' - New: '+IntToStr(imgpkg.imgx)+'x'+IntToStr(imgpkg.imgy)+')'+CrLf+
                            'Replace anyways?'),
                    PChar(list_txmp.Items.Strings[list_txmp.ItemIndex]),
                    MB_YESNO)=IDNO THEN Exit;
      END;

      rawfile:=TFileStream.Create(raw_filename,fmOpenReadWrite);

      CASE oldstore OF
        9: oldsize:=GetImageDataSize(oldwidth,oldheight,8,(oldfading AND $01)>0);
        0,1,2: oldsize:=GetImageDataSize(oldwidth,oldheight,16,(oldfading AND $01)>0);
        8: oldsize:=GetImageDataSize(oldwidth,oldheight,32,(oldfading AND $01)>0);
      ELSE
        oldsize:=0;
      END;
      IF check_32bit.Checked THEN
        newsize:=GetImageDataSize(imgpkg.imgx,imgpkg.imgy,32,check_fading.Checked)
      ELSE
        newsize:=GetImageDataSize(imgpkg.imgx,imgpkg.imgy,16,check_fading.Checked);

      IF newsize<=oldsize THEN
        new_rawaddr:=old_rawaddr
      ELSE
        new_rawaddr:=rawfile.Size;

      datbyte:=$00;
      IF check_fading.Checked THEN datbyte:=datbyte OR $01;
      UpdateDatFilePart(id,$88,1,@datbyte);
      datbyte:=$10;
      IF check_transparency.Checked THEN datbyte:=datbyte OR $04;
      UpdateDatFilePart(id,$89,1,@datbyte);
      UpdateDatFilePart(id,$8C,2,@imgpkg.imgx);
      UpdateDatFilePart(id,$8E,2,@imgpkg.imgy);
      IF check_32bit.Checked THEN
        datbyte:=$08
      ELSE
        datbyte:=$01;
      UpdateDatFilePart(id,$90,1,@datbyte);
      UpdateDatFilePart(id,$9C,4,@new_rawaddr);

      IF check_fading.Checked THEN BEGIN
        imgpkg.imgdata:=CreateFadedImage(imgpkg);
      END;

      rawfile.Seek(new_rawaddr,soFromBeginning);
      rawfile.Write(imgpkg.imgdata[0],Length(imgpkg.imgdata));
      rawfile.Free;
      
      ShowMessage('TXMP-image replaced');
    END;
  END;

PROCEDURE TForm7.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    Action:=caFree;
    Form1.close_window(Self.Name);
  END;

PROCEDURE TForm7.FormActivate(Sender: TObject);
  BEGIN
    Form1.SetActiveWindow(Self.Name);
  END;

PROCEDURE TForm7.btn_saveClick(Sender: TObject);
  VAR
    filestream:TFileStream;
    img:TImgPackage;
  BEGIN
    IF saved.Execute THEN BEGIN
      img:=LoadImgData(StrToInt(MidStr(list_txmp.Items.Strings[list_txmp.ItemIndex],1,5)));
      img.imgdata:=ImgdataToBMP(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      filestream:=TFileStream.Create(saved.FileName,fmCreate);
      filestream.Write(img.imgdata[0],Length(img.imgdata));
      filestream.Free;
    END;
  END;

END.
