#include <string>
#include <vector>
#include <fstream>

using namespace std;

struct ModPackage {
	bool	isInstalled; //replace with function 
	string	name;
	string	modString;
	bool	hasOnis;
	bool	hasDeltas;
	bool	hasBSL;
	bool	hasDats;
	bool	category;
	string	creator;
	bool	isEngine;
	string	readme;
	bool	globalNeeded;
};

int mainMenu();
vector<ModPackage> getPackages();
ModPackage fileToModPackage(fstream&);

void installPackages();
void uninstallPackages();
void getInstalledPackages();

bool getDirectoryContents(char , char &);


void Tokenize(const string& str,
                      vector<string>& tokens,
                      const string& delimiters = " ")
{
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}