#include <string>
#include <vector>
#include <fstream>

using namespace std;

struct ModPackage {
	bool	isInstalled; //replace with function 
	string	name;
	string	modStringName;
	int	modStringVersion;
	bool	hasOnis;
	bool	hasDeltas;
	bool	hasBSL;
	bool	hasDats;
	string	category;
	string	creator;
	bool	isEngine;
	string	readme;
	bool	globalNeeded;
	ModPackage();
	void doOutput() {
			cout << "Mod: " << name; cout << "\n"; //remove this when done
			cout << "	String: " << modStringName << " v." << modStringVersion << "\n";
			cout << "	Category: " << category << "\n";
			cout << "	Creator: " << creator << "\n";
			cout << "	HasOnis: " << hasOnis << "\n";
			cout << "	HasBSL: " << hasBSL << "\n";
			cout << "	HasDeltas: " << hasDeltas << "\n";
			cout << "	HasDats: " << hasDats << "\n";
			cout << "	IsEngine: " << isEngine << "\n";
			cout << "	GlobalNeeded: " << globalNeeded << "\n";
			cout << "	Readme: " << readme << "\n";
			cout << "\n";
}

};
//Initialization
ModPackage::ModPackage() {
		isInstalled = 0; //replace with function 
		name = "";
		modStringName = "";
		modStringVersion = 0;
		hasOnis = 0;
		hasDeltas = 0;
		hasBSL = 0;
		hasDats = 0;
		category = "";
		creator = "";
		isEngine = 0;
		readme = "";
		globalNeeded = 1;
//		void doOutput() const
//		{ };
}

int mainMenu();
vector<ModPackage> getPackages();
ModPackage fileToModPackage(fstream&);

void installPackages();
void uninstallPackages();
void getInstalledPackages();

bool getDirectoryContents(char , char &);


void Tokenize(const string& str,
			  vector<string>& tokens,
			  const string& delimiters = " ")
{
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(delimiters, 0);
	// Find first "non-delimiter".
	string::size_type pos     = str.find_first_of(delimiters, lastPos);

	while (string::npos != pos || string::npos != lastPos)
	{
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = str.find_first_not_of(delimiters, pos);
		// Find next "non-delimiter"
		pos = str.find_first_of(delimiters, lastPos);
	}
}