#include "daodan_gl.h"

#define max_modes (104) // Dirty hack to add more resolutions, it really should only be 16 ^_^
#define builtin_modes  (sizeof(daodan_reslist) / sizeof(M3tDisplayMode))
#define builtin_depths (sizeof(daodan_resdepths) / sizeof(short))

const M3tDisplayMode daodan_reslist[] = {
	{ 720 , 480,  0, 0 },
	{ 720 , 576,  0, 0 },
	{ 768 , 480,  0, 0 },
	{ 800 , 480,  0, 0 },
	{ 852 , 480,  0, 0 },
	{ 856 , 480,  0, 0 },
	{ 960 , 540,  0, 0 },
	{ 960 , 720,  0, 0 },
	{ 1024, 576,  0, 0 },
	{ 1024, 600,  0, 0 },
	{ 1024, 640,  0, 0 },
	{ 1024, 768,  0, 0 },
	{ 1152, 768,  0, 0 },
	{ 1152, 864,  0, 0 },
	{ 1280, 720,  0, 0 },
	{ 1280, 768,  0, 0 },
	{ 1280, 800,  0, 0 },
	{ 1280, 960,  0, 0 },
	{ 1280, 1024, 0, 0 },
	{ 1366, 768,  0, 0 },
	{ 1400, 1050, 0, 0 },
	{ 1440, 900,  0, 0 },
	{ 1600, 900,  0, 0 },
	{ 1600, 1200, 0, 0 },
	{ 1920, 1080, 0, 0 },
	{ 1920, 1440, 0, 0 },
};

const short daodan_resdepths[] = { 16, 32 };

unsigned int ONICALL daodan_enumerate_valid_display_modes(M3tDisplayMode modes[max_modes])
{
	unsigned int vmodes = 0;
	unsigned int screen_x = GetSystemMetrics(SM_CXSCREEN);
	unsigned int screen_y = GetSystemMetrics(SM_CYSCREEN);
	
	int i, j;
	
	for (i = 0; i < builtin_depths; i ++)
	{
		modes[vmodes].Width  = 640;
		modes[vmodes].Height = 480;
		modes[vmodes].Depth  = daodan_resdepths[i];
		
		if (++vmodes == max_modes - builtin_modes + i)
			goto modesfull;
		
		for (j = 0; j < builtin_modes; j ++)
			if (!(daodan_reslist[j].Width == 640 && daodan_reslist[j].Height == 480) && !(daodan_reslist[j].Width == screen_x && daodan_reslist[j].Height == screen_y) &&
				((daodan_reslist[j].Width < screen_x && daodan_reslist[j].Height < screen_y) || daodan_testmode(daodan_reslist[j])))
			{
				modes[vmodes].Width  = daodan_reslist[j].Width;
				modes[vmodes].Height = daodan_reslist[j].Height;
				modes[vmodes].Depth  = daodan_resdepths[i];
				
				if (++vmodes == max_modes - builtin_modes + i)
					goto modesfull;
			}
		
		modes[vmodes].Width  = GetSystemMetrics(SM_CXSCREEN);
		modes[vmodes].Height = GetSystemMetrics(SM_CYSCREEN);
		modes[vmodes].Depth  = daodan_resdepths[i];
		
		if (++vmodes == max_modes - builtin_modes + i)
			goto modesfull;
	}
	
	modesfull:
	return vmodes;
}

bool daodan_testmode(M3tDisplayMode mode)
{
	DEVMODE devmode;
	memset(&devmode, 0, sizeof(devmode));
	
	devmode.dmSize = sizeof(devmode);
	devmode.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
	devmode.dmBitsPerPel = mode.Depth;
	devmode.dmPelsWidth  = mode.Width;
	devmode.dmPelsHeight = mode.Height;
	
	return (ChangeDisplaySettings(&devmode, CDS_TEST) == DISP_CHANGE_SUCCESSFUL);
}
