/* AE/Mod Installer header file */

#include <string>
#include <vector>
#include <fstream>

using namespace std;

static string SLASHSLASH = "//";
static string DIRSLASH = "\\";

#define STRUCT_DEFS 
struct ModPackage
{
	bool	isInstalled; //replace with function 
	string	name;
	string	modStringName;
	int	modStringVersion;
	bool	hasOnis;
	bool	hasDeltas;
	bool	hasBSL;
	bool	hasDats;
	string	category;
	string	creator;
	bool	isEngine;
	string	readme;
	bool	globalNeeded;
	ModPackage();
	void doOutput()
	{
		cout << "Mod: " << name; cout << "\n"; // remove this when done
		cout << "	String: " << modStringName << " v." << modStringVersion << "\n";
		cout << "	Category: " << category << "\n";
		cout << "	Creator: " << creator << "\n";
		cout << "	HasOnis: " << hasOnis << "\n";
		cout << "	HasBSL: " << hasBSL << "\n";
		cout << "	HasDeltas: " << hasDeltas << "\n";
		cout << "	HasDats: " << hasDats << "\n";
		cout << "	IsEngine: " << isEngine << "\n";
		cout << "	GlobalNeeded: " << globalNeeded << "\n";
		cout << "	Readme: " << readme << "\n";
		cout << "\n";
	}

};

#define METHOD_DEFS 
// Initialization to default values
ModPackage::ModPackage()
{
	isInstalled = true; // replace with function 
	name = "";
	modStringName = "";
	modStringVersion = 0;
	hasOnis = false;
	hasDeltas = false;
	hasBSL = false;
	hasDats = false;
	category = "";
	creator = "";
	isEngine = false;
	readme = "";
	globalNeeded = true;
	//		void doOutput() const
	//		{ };
}

#define FUNCTION_PROTOTYPES 
int mainMenu(void);
int globalizeData(void);
int installPackages(void);
int uninstallPackages(void);
int listInstalledPackages(void);
int printInstallerInfo(void);
vector<ModPackage> getPackages(void);
ModPackage fileToModPackage(fstream&);
void recompileAll(vector<string>);
vector<string> getInstallString(void);
void tokenize(const string&, vector<string>&, const string& delimiters = " ");
//bool getDirectoryContents(char , char &);
void clearOldDats(void);
void writeInstalledMods( vector<string> );

//New copy(path, path) function. Too lazy to implement my own, this is basically how I would have done it though.
//No, really. :)
//Move to utilities.cpp when the time comes.
using namespace boost::filesystem; 
using namespace std;

void copy_directory( const path & from_dir_ph, 
 const path & to_dir_ph ); 
 
 void copy( const path & from_file_ph, 
 const path & to_file_ph ); 


// this function copies files and directories. If copying a 
// directory to a directory, it copies recursively. 

 //pardon the mess, I did this at midnight, and had to fix a bug
void copy( const path & from_ph, 
		  const path & to_ph ) 
{ 
	cout << to_ph.string() << "\n";
	// Make sure that the destination, if it exists, is a directory 
	if((exists(to_ph) && !is_directory(to_ph)) || (!exists(from_ph))) cout << "error";
	if(!is_directory(from_ph)) 
	{ 
		
		if(exists(to_ph)) 
		{ 
			copy_file(from_ph,to_ph/from_ph.filename()); 
		} 
		else 
		{ 
			try{
			
			copy_file(from_ph,to_ph);
			}
			catch (exception ex){
			cout << from_ph.string() << " to " << to_ph.string() << "\n";
			}
		}

	} 
	else if(from_ph.filename() != ".svn")
	{ 
		path destination; 
		if(!exists(to_ph)) 
		{ 
			destination=to_ph; 
		} 
		else 
		{ 
			destination=to_ph/from_ph.filename(); 
		} 
		//not sure what this did, its going away though. probably error checking ;)
		//copy_directory(from_ph,destination); 

		for(directory_iterator i(from_ph); i!=directory_iterator(); ++i) 
		{ 
			//the idiot who coded this in the first place (not me)
			//forgot to make a new directory. Exception city. x_x
			create_directory(destination); 
			copy(*i,destination/i->filename()); 
		} 
	} 
} 

void copy_directory( const path &from_dir_ph, 
					const path &to_dir_ph) 
{ 
	if(!exists(from_dir_ph) || !is_directory(from_dir_ph) 
		|| exists(to_dir_ph)) 
		cout << !exists(from_dir_ph) << " " << !is_directory(from_dir_ph) 
		<< " " << exists(to_dir_ph);
		//boost::throw_exception( filesystem_error( 
		//"boost::filesystem::copy_directory", 
		//from_dir_ph, to_dir_ph, boost::system::error_code() )); 

# ifdef BOOST_POSIX 
	struct stat from_stat; 
	if ( (::stat( from_dir_ph.string().c_str(), &from_stat ) != 0) 
		|| ::mkdir(to_dir_ph.native_directory_string().c_str(), 
		from_stat.st_mode)!=0) 
# endif 
	//	boost::throw_exception( filesystem_error( 
	//	//"boost::filesystem::copy_directory", 
	//	from_dir_ph, to_dir_ph, boost::system::error_code())); 
} 

