/*
AE/Mod Installer
by Gumby and Iritscen
*/

// To-do: - Load credits from text resource file
//		  - Version number in credits should be universalized
//		  - Institute lots of checks into file-handling
//		  - Clear mod info fields when mod is de-selected

#define DEBUG
#include <stdio.h>
//#include <conio.h>
//#include <process.h>
#include <string>
#include <iostream>
#include <cctype>
#include <vector>
#include <fstream>
#include <errno.h>
#include <sstream>

#include "boost/filesystem.hpp" // includes all needed Boost.Filesystem declarations
#include "boost/lexical_cast.hpp" //int -> string
#include "installer.h"

#ifdef WIN32
#include <windows.h>
#else // assume we're on Mac
#include <stdlib.h>
#include <dirent.h>
#endif

const string strInstallerVersion = "1.0";
const bool SPLIT = 1;
const bool NOT_SPLIT = 0;
bool splitInstances = SPLIT;
bool busy = 0;
#ifdef WIN32
const string strOniSplit = "Onisplit.exe";
string strImportOption = "-import:nosep";
const char* strClsCmd = "cls";
const char* strPauseCmd = "PAUSE";
#else // set up Mac equivalents since we're in Mac OS
const string strOniSplit = "mono Onisplit.exe";
string strImportOption = "-import:sep";
const char* strClsCmd = "clear";
const char* strPauseCmd = "read -n 1 -p \"Press any key to continue\"";
void Sleep(int ms) { sleep( ms / 1000 ); }
#endif

using namespace boost::filesystem; 
using namespace std;




#include "boost/date_time/gregorian/gregorian.hpp"
#include "boost/date_time/date_parsing.hpp"
#include "boost/date_time/posix_time/posix_time.hpp" 

int globalizeData(void)
{
	busy = 1;
	using boost::lexical_cast;
	using boost::bad_lexical_cast;
	// using namespace boost::posix_time;
	using namespace boost::gregorian;
	using namespace boost::posix_time;
	ptime start_time(second_clock::local_time());

	setStatusArea("Globalizing!");
	int err = 0;
	int parts_done = 0;
	char Step_x_x[300];
	//char levels[i][5];
	remove("Globalize.log");
	ofstream logfile("Globalize.log");
	logfile << "Globalization started " << to_simple_string(start_time) << endl;
	try {

		char levels_cstr[15][3] = {"0", "1", "2", "3", "4", "6", "8", "9", "10", "11", "12", "13", "14", "18", "19"}; // the levels Oni has...probably should have made a string array. Oops.
		//const vector<double> ck(cv, &cv[CvSize]);
		vector<string> levels;
		for (int f = 0; f < 15; f++) {
			levels.push_back(levels_cstr[f]);
		}
		char choice = 0;

		//SetCurrentDirectory("C:/Program Files/Oni/edition/install");
		///char levels[i][3];
		path Characters = "../GameDataFolder/level0_Characters";
		path Particles = "../GameDataFolder/level0_Particles";
		path Archive = "../GameDataFolder/Archive";
		path Textures  = "../GameDataFolder/level0_Textures";
		path Sounds = "../GameDataFolder/level0_Sounds";
		path Animations = "../GameDataFolder/level0_Animations";
		path TRAC = Animations / "level0_TRAC";
		path TRAM = Animations / "level0_TRAM";

		vector<path> GDFPaths;
		GDFPaths.push_back(Characters);
		GDFPaths.push_back(Particles);
		GDFPaths.push_back(Textures);
		GDFPaths.push_back(Sounds);
		GDFPaths.push_back(TRAC);
		GDFPaths.push_back(TRAM);


		path VanillaCharacters = "packages/VanillaDats/level0_Final/level0_Characters/level0_Characters.oni";
		path VanillaParticles = "packages/VanillaDats/level0_Final/level0_Particles/level0_Particles.oni";
		path VanillaTextures  = "packages/VanillaDats/level0_Final/level0_Textures/level0_Textures.oni";
		path VanillaSounds = "packages/VanillaDats/level0_Final/level0_Sounds/level0_Sounds.oni";
		path VanillaAnimations = "packages/VanillaDats/level0_Final/level0_Animations/level0_Animations.oni";
		path VanillaTRAC = "packages/VanillaDats/level0_Final/level0_Animations/level0_TRAC.oni";
		path VanillaTRAM = "packages/VanillaDats/level0_Final/level0_Animations/level0_TRAM.oni";

		vector<path> VanillaPaths;

		VanillaPaths.push_back(VanillaCharacters);
		VanillaPaths.push_back(VanillaParticles);
		VanillaPaths.push_back(VanillaTextures);
		VanillaPaths.push_back(VanillaSounds);
		VanillaPaths.push_back(VanillaTRAC);
		VanillaPaths.push_back(VanillaTRAM);

		/*
		if (exists("../GameDataFolder/"))
		{
		//cout << "\nIt looks like you've already globalized Oni's data.\nDo you want to re-globalize?\n(This will erase existing mods installed to the AE's game data.)"
		//	 << "\n1. Re-globalize"
		//	 << "\n2. Return to main menu\n";
		//choice = cin.get();
		cin.ignore(128, '\n');
		if (choice == '1')
		remove_all("../GameDataFolder"); // remove AE GDF
		if (choice == '2')
		return 0;
		}
		*/
		setStatusArea("Removing old GameDataFolder...\n");
		logfile <<  "Removing old GameDataFolder...\n";
		remove_all( "../GameDataFolder/" );
		setStatusArea("Creating needed directories...");
		logfile <<  "Creating needed directories...\n";
		create_directory( "../GameDataFolder/" );

		create_directory( "packages" );

		if (exists("packages/VanillaDats")) remove_all("packages/VanillaDats"); 
		create_directory( "packages/VanillaDats" );

		create_directory( "packages/VanillaDats/level0_Final/" );
		//blah blah finish this.
		//logfile <<  "packages/VanillaDats/level0_Final/ created";
		create_directory( Characters );
		create_directory( Particles );
		create_directory( Archive );
		create_directory( Textures );
		create_directory( Sounds );
		create_directory( Animations );
		create_directory( TRAC );
		create_directory( TRAM );
		int num_levels = 0;
		for(int i = 1; i < 15; i++)
		{
			if (exists("../../GameDataFolder/level" + levels[i] + "_Final.dat")) {
				num_levels++;

			}
		}
		logfile << "Exporting and moving...\n\n";
		int total_steps =  8 + 2 * num_levels;
		for(int i = 0; i < 15; i++)
		{

			//printf(levels[i],"%d",levels[i]); // int to char array

			if (exists("../../GameDataFolder/level" + levels[i] + "_Final.dat")) {
				logfile << "level" << levels[i] << "_Final\n";
				logfile << "\tExporting level" << levels[i] << "_Final.dat\n";
				//printf(Step_x_x,"Step %d/%d: exporting level%d_final.dat", parts_done + 1,, levels[i]); setStatusArea((string)Step_x_x);
				setStatusArea("Step " + lexical_cast<std::string>(parts_done + 1) + "/" + lexical_cast<std::string>(total_steps) + " exporting level" + levels[i]+"_Final.dat");
				create_directory( "../GameDataFolder/level" + levels[i] + "_Final" ); 
				//				setStatusArea(strOniSplit + " -export ../GameDataFolder/level" + levels[i] + "_Final ../../GameDataFolder/level" + levels[i] + "_Final.dat");
				system((strOniSplit + " -export ../GameDataFolder/level" + levels[i] + "_Final ../../GameDataFolder/level" + levels[i] + "_Final.dat").c_str());
				create_directory( "packages/VanillaDats/level" + levels[i] + "_Final" ); 
				create_directory( "packages/VanillaDats/level" + levels[i] + "_Final/level" + levels[i] + "_Final" );

				directory_iterator end_iter;
				for ( directory_iterator dir_itr( "../GameDataFolder/level" + levels[i] + "_Final" ); dir_itr != end_iter; ++dir_itr )
				{
					//cout << dir_itr->path().filename();
					if ( is_regular_file( dir_itr->status() ) )
					{
						if ( dir_itr->path().filename().substr(0,8) == "TXMPfail" || 
							dir_itr->path().filename().substr(0,9) == "TXMPlevel" ||
							( dir_itr->path().filename().substr(0,4) == "TXMP" && dir_itr->path().filename().find("intro")!=string::npos) ||
							dir_itr->path().filename().substr(0,4) == "TXMB" || 
							dir_itr->path().filename() == "M3GMpowerup_lsi.oni" ||
							dir_itr->path().filename() == "TXMPlsi_icon.oni" ||
							( dir_itr->path().filename().substr(0,4) == "TXMB" && dir_itr->path().filename().find("splash_screen.oni")!=string::npos)	)
						{
							cout <<dir_itr->path().filename() << "\n";
							create_directory( dir_itr->path().parent_path() / "NoGlobal");	
							if(!exists( dir_itr->path().parent_path() / "NoGlobal" / dir_itr->filename())) rename(dir_itr->path(), dir_itr->path().parent_path() / "NoGlobal" /
								dir_itr->filename());
							else remove(dir_itr->path());
						}
						else if (dir_itr->path().filename().substr(0,4) == "TRAC"
							|| dir_itr->path().filename().substr(0,4) == "ONVL") {
								cout <<dir_itr->path().filename() << "\n";
								if(!exists( TRAC / dir_itr->filename())) rename(dir_itr->path(), TRAC / dir_itr->filename());
								else remove(dir_itr->path());
						}
						else if (dir_itr->path().filename().substr(0,4) == "TRAM") {
							cout <<dir_itr->path().filename() << "\n";
							if(!exists( TRAM / dir_itr->filename())) rename(dir_itr->path(), TRAM / dir_itr->filename());
							else remove(dir_itr->path());
						}
						else if (dir_itr->path().filename().substr(0,4) == "ONSK" ||
							dir_itr->path().filename().substr(0,4) == "TXMP") {
								cout <<dir_itr->path().filename() << "\n";\
									create_directory( dir_itr->path().parent_path() / "TexFix");	
								if(!exists( Textures / dir_itr->filename())) rename(dir_itr->path(), Textures / dir_itr->filename());
								//rename(dir_itr->path(), dir_itr->path().parent_path() / "TexFix" / dir_itr->filename());
						}
						else if (dir_itr->path().filename().substr(0,4) == "ONCC" 
							|| dir_itr->path().filename().substr(0,4) == "TRBS"
							|| dir_itr->path().filename().substr(0,4) == "ONCV"
							|| dir_itr->path().filename().substr(0,4) == "TRMA"
							|| dir_itr->path().filename().substr(0,4) == "TRSC"
							|| dir_itr->path().filename().substr(0,4) == "TRAS") {
								cout <<dir_itr->path().filename() << "\n";
								if(!exists( Characters / dir_itr->filename())) rename(dir_itr->path(), Characters / dir_itr->filename());
								else remove(dir_itr->path());
						}
						else if (dir_itr->path().filename().substr(0,4) == "OSBD"
							|| dir_itr->path().filename().substr(0,4) == "SNDD") {
								cout << dir_itr->path().filename() << "\n";
								if(!exists( Sounds / dir_itr->filename())) rename(dir_itr->path(), Sounds / dir_itr->filename());
								else remove(dir_itr->path());
						}
						else if (dir_itr->path().filename().substr(0,5) == "BINA3"
							|| dir_itr->path().filename().substr(0,10) == "M3GMdebris"
							|| dir_itr->path().filename() == "M3GMtoxic_bubble.oni"
							|| dir_itr->path().filename().substr(0,8) == "M3GMelec"
							|| dir_itr->path().filename().substr(0,7) == "M3GMrat"
							|| dir_itr->path().filename().substr(0,7) == "M3GMjet"
							|| dir_itr->path().filename().substr(0,9) == "M3GMbomb_"
							|| dir_itr->path().filename() == "M3GMbarab_swave.oni"
							|| dir_itr->path().filename() == "M3GMbloodyfoot.oni"
							){
								cout <<dir_itr->path().filename() << "\n";
								if(!exists( Particles / dir_itr->filename())) rename(dir_itr->path(), Particles / dir_itr->filename());
								else remove(dir_itr->path());
						}
						else if (dir_itr->path().filename().substr(0,4) == "AGDB"
							|| dir_itr->path().filename().substr(0,4) == "TRCM") {
								cout <<dir_itr->path().filename() << "\n";

								if(!exists( Archive / dir_itr->filename())) rename(dir_itr->path(), Archive / dir_itr->filename());
								else remove(dir_itr->path());
						}
						if (exists(dir_itr->path())) {

						}
						else {
							logfile << "\tMoved file: " << dir_itr->path().filename() << "\n";
						}
					}



				}
				logfile << "\tCleaning up TXMPs...\n";
				system( (strOniSplit + " -move:delete " + Textures.string() + " ../GameDataFolder/level" + levels[i] + "_Final/TXMP*.oni").c_str());
				parts_done++;

				setProgressBar( (int)(1000 * (float)(parts_done) / (float)(total_steps) )); 

			}
		}
		logfile << "Reimporting levels\n";
		for (int i = 0; i < 15; i++)
		{
			logfile << "\tReimporting level" << levels[i] << "_Final.oni\n";
			//printf(levels[i],"%d",levels[i]);
			//printf(Step_x_x,"Step %d/%d: reimporting level", parts_done + 1, 7 + 2 * num_levels); setStatusArea((string)Step_x_x + levels[i] + (string)"_Final.dat");
			setStatusArea("Step " + lexical_cast<std::string>(parts_done + 1) + "/" + lexical_cast<std::string>(total_steps) + " reimporting level" + levels[i]+"_Final.oni");
			system( (strOniSplit + " " + strImportOption + " ../GameDataFolder/level" + levels[i] + "_Final packages/VanillaDats/level" + levels[i] + "_Final/level"
				+ levels[i] + "_Final/level" + levels[i] + "_Final.oni > Globalize.log").c_str());
			setProgressBar( (int)(1000 * (float)(parts_done) / (float)(total_steps) ));
			parts_done++;
		}
		create_directory( VanillaCharacters.parent_path() );
		create_directory( VanillaParticles.parent_path() );
		create_directory( VanillaTextures.parent_path() );
		create_directory( VanillaSounds.parent_path() );
		create_directory( VanillaAnimations.remove_filename() );

		for(int j = 0; j < GDFPaths.size(); j++) {
			logfile << "\tReimporting " << GDFPaths[j].filename() << ".oni\n";
			setStatusArea("Step " + lexical_cast<std::string>(parts_done + 1) + "/" + lexical_cast<std::string>(total_steps) + ": reimporting " + GDFPaths[j].filename() );
			system((strOniSplit + " " + strImportOption + " " + GDFPaths[j].string() + " " + VanillaPaths[j].string()).c_str());
			parts_done++;
			setProgressBar( (int)(1000 * (float)(parts_done) / (float)(total_steps) )); 
		}
		/*
		printf(Step_x_x,"Step %d/%d: reimporting level0_Characters", parts_done,7 + 2 * num_levels); setStatusArea((string)Step_x_x);setProgressBar( (int)(1000 * (float)(parts_done) / (float)(7 + 2 * num_levels) )); 
		system((strOniSplit + " " + strImportOption + " " + Characters.string() + " " + VanillaCharacters.string()).c_str());
		parts_done++; printf(Step_x_x,"Step %d/%d: reimporting level0_Particles", parts_done,7 + 2 * num_levels); setStatusArea((string)Step_x_x);setProgressBar( (int)(1000 * (float)(parts_done) / (float)(7 + 2 * num_levels) )); 
		system((strOniSplit + " " + strImportOption + " " + Particles.string() + " " + VanillaParticles.string()).c_str());
		parts_done++; printf(Step_x_x,"Step %d/%d: reimporting level0_Textures", parts_done,7 + 2 * num_levels); setStatusArea((string)Step_x_x);setProgressBar( (int)(1000 * (float)(parts_done) / (float)(7 + 2 * num_levels) )); 
		system((strOniSplit + " " + strImportOption + " " + Textures.string() + " " + VanillaTextures.string()).c_str());
		//system((strOniSplit	+ " " + strImportOption + (string)" " + Animations.string() + (string)" " + VanillaAnimations.string()).c_str());
		parts_done++; printf(Step_x_x,"Step %d/%d: reimporting level0_TRAC", parts_done,7 + 2 * num_levels); setStatusArea((string)Step_x_x);setProgressBar( (int)(1000 * (float)(parts_done) / (float)(7 + 2 * num_levels) )); 
		system((strOniSplit + " " + strImportOption + " " + TRAC.string() + " " + VanillaTRAC.string()).c_str());
		parts_done++; printf(Step_x_x,"Step %d/%d: reimporting level0_Sounds", parts_done,7 + 2 * num_levels); setStatusArea((string)Step_x_x);setProgressBar( (int)(1000 * (float)(parts_done) / (float)(7 + 2 * num_levels) )); 
		system((strOniSplit + " " + strImportOption + " " + Sounds.string() + " " + VanillaSounds.string()).c_str());
		parts_done++; printf(Step_x_x,"Step %d/%d: reimporting level0_TRAM", parts_done,7 + 2 * num_levels); setStatusArea((string)Step_x_x);setProgressBar( (int)(1000 * (float)(parts_done) / (float)(7 + 2 * num_levels) )); 
		system((strOniSplit + " " + strImportOption + " " + TRAM.string() + " " + VanillaTRAM.string()).c_str()); 
		//parts_done++; setStatusArea((string)"Copying level scripts...");setProgressBar( (int)(1000 * (float)(parts_done) / (float)(7 + 2 * num_levels) )); 
		if (exists("../GameDataFolder/IGMD")) remove_all("../GameDataFolder/IGMD");
		*/
		create_directory((path)"../GameDataFolder/IGMD");
		copy((path)"packages/VanillaBSL/IGMD", (path)"../GameDataFolder");
		setProgressBar( 1000 ); 
		setStatusArea((string)"Done! Now select your mod packages and click install.");
		//	while(1) Sleep(-1);

	}
	catch (exception ex) {
		setStatusArea("Warning, handled exception: " + (string)ex.what());
	}

	ptime end_time(second_clock::local_time());
	time_period total_time (start_time, end_time);
	logfile << "\n\nGlobalization ended " << to_simple_string(end_time) << "\nThe process took " << total_time.length();
	//total_time.length().hours();
	logfile.close();
	busy = 0;
	return err;
}


vector<ModPackage> getPackages(void)
{
	vector<ModPackage> packages;
	packages.reserve(65536); // come on, we shouldn't need this much space...right?!
	fstream file;
	string filename = "\0";
	string MODINFO_CFG = "Mod_Info.cfg";

	try
	{
		directory_iterator end_iter;
		for (directory_iterator dir_itr("./packages"); dir_itr != end_iter; ++dir_itr)
		{
			file.open((dir_itr->path().string() + "/" + MODINFO_CFG).c_str());
			//cout << filename << "\n";

			if(!file.fail())
			{
				//cout << dir_itr->path().string() + MODINFO_CFG;
				//would prefer to push a pointer to a package, but this will do for now
				packages.push_back(fileToModPackage(file));
			}	
			file.close();
			file.clear();
		}
		sort(packages.begin(), packages.end());
	}
	catch (const std::exception & ex)
	{
		cout << "Warning, something odd happened!\n";
	}

	return packages;
}

ModPackage fileToModPackage(fstream &file)
{
	/*
	This converts a file to a ModPackage struct.

	A few notes...
	"iter" is the current word we are on. I should have named it "token" or something, but I don't have multiple iterators, so its ok.
	I refer to (*iter) at the beginning of each if statement block. I could probably store it as a variable, but I'm pretty sure that dereferencing a pointer\iterator isn't much
	slower than reading a variable.
	*/
	ModPackage package;
	string line;
	static string NameOfMod = "NameOfMod";	//used for comparing to the current token...
	//I could have done it in reverse (*iter).compare("ModString") or  
	static string ARROW = "->";				//did something like "ModString".compare(*iter), and it would have been
	static string ModString = "ModString";	//functionably the same. 
	static string HasOnis = "HasOnis";
	static string HasDeltas = "HasDeltas";
	static string HasBSL = "HasBSL";
	static string HasDats = "HasDats";
	static string IsEngine = "IsEngine";
	static string Readme = "Readme";
	static string GlobalNeeded = "GlobalNeeded";
	static string Category = "Category";
	static string Creator = "Creator";
	while (! file.eof() )
	{
		getline (file,line);
		vector<string> tokens; 
		vector<string>::iterator iter;
		tokenize(line, tokens);					//string to vector of "words"
		if (tokens.capacity() >= 2) {			//make sure they are using enough stuff
			iter = tokens.begin();				//what word we are on, starts at first word
			/*
			if (!AEInstallVersion.compare(*iter))
			If mod is too old, skip this mod.
			*/
			/*else*/if (!NameOfMod.compare(*iter))  {	//if it contains the name
				for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
					if (ARROW.compare(*iter) && NameOfMod.compare(*iter)) {			//ignores "->" and "NameOfMod"
						//cout << *iter; 
						//cout << " ";
						package.name += *iter + " ";
					}
				}

			}
			else if (!ModString.compare(*iter)) {
				iter++; iter++;
				package.modStringName = *iter;
				iter++;
				package.modStringVersion = atoi((*iter).c_str());
			}
			else if (!HasOnis.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.hasOnis = 1; //Gotta love c++'s lack of a standard case-insensitive
				else if (!HasBSL.compare(*iter)) { // string comparer...I know my implementation here sucks. I need to change it to check each character one by one. At the moment,
					iter++; iter++;}  // using "YFR" would probably set it off. :<

				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.hasBSL = 1;
			}
			else if (!HasDeltas.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.hasDeltas = 1;
			}
			else if (!HasDats.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.hasDats = 1;
			}
			else if (!IsEngine.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.isEngine = 1;
			}
			else if (!GlobalNeeded.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.globalNeeded = 1;
				else if (toupper((*iter)[0]) + toupper((*iter)[1]) == 'N' + 'O') package.globalNeeded = 1; //Really the only place where checking for "No" is important atm.
			}
			else if (!Category.compare(*iter))  {	
				for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
					if (ARROW.compare(*iter) && Category.compare(*iter)) {			//ignores "->" and "Category"
						//cout << *iter; 
						//cout << " ";
						package.category += *iter + " ";
					}
				}
			}
			else if (!Creator.compare(*iter))  {	//if it contains the name
				for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
					if (ARROW.compare(*iter) && Creator.compare(*iter)) {			//ignores "->" and "Category"
						//cout << *iter; 
						//cout << " ";
						package.creator += *iter + " ";
					}
				}
			}
			else if (!Readme.compare(*iter))  {	//if it contains the name
				for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
					if (ARROW.compare(*iter) && Readme.compare(*iter)) {			//ignores "->" and "Category"
						if(!(*iter).compare("\\n")) package.readme += '\n';
						else package.readme += *iter + " ";
					}
				}
			}
		}

	}
	package.doOutput();
	return package;
}

void recompileAll(vector<string> installedMods)
{
	busy = 1;
	using namespace boost::gregorian;
	using namespace boost::posix_time;
	using boost::lexical_cast;
	using boost::bad_lexical_cast;
	
	setStatusArea("Importing levels...");
	//setStatusArea("Recompiling Data...");
	path vanilla_dir = "./packages/VanillaDats/";
	string importCommand = "";
	char statusString[128];
	int numberOfDats = 0;
	int j = 1;
	string datString;
	std::stringstream out;

	ptime start_time(second_clock::local_time());
	clearOldDats();
	remove("Install.log");
	ofstream logfile("Install.log");
	logfile << "Mod Installation started " << to_simple_string(start_time) << endl;
	logfile.close();
	if(splitInstances == SPLIT){
		recursive_directory_iterator end_iter;

		for ( recursive_directory_iterator dir_itr( vanilla_dir );
			dir_itr != end_iter;
			++dir_itr )
		{
			try{
				if ( is_directory( dir_itr->status() ) &&  dir_itr.level() == 1)
				{
					numberOfDats++;
				}
			}
			catch(exception ex) {

			}
		}

		//recursive_directory_iterator end_iter;


		out << numberOfDats;
		datString = out.str();
		try {
			for ( recursive_directory_iterator dir_itr( vanilla_dir );
				dir_itr != end_iter;
				++dir_itr )
			{
				try
				{
					if ( is_directory( dir_itr->status() ) &&  dir_itr.level() == 1)
					{
						importCommand = strOniSplit + " " + strImportOption + " " + dir_itr->path().parent_path().string() + '/' + dir_itr->path().filename();
						for (int i = 0; i < installedMods.size(); ++i) {
							if (exists("packages/" + installedMods[i] + "/oni/" + dir_itr->path().parent_path().filename() + '/' + dir_itr->path().filename()  ))
								importCommand += " packages/" + installedMods[i] + "/oni/" + dir_itr->path().parent_path().filename() + '/' + dir_itr->path().filename();

							//else cout << " packages/VanillaDats/" + installedMods[i] + "/oni/";
						}
						importCommand += " ../GameDataFolder/" + dir_itr->path().filename() + ".dat >> Install.log";

						
						setProgressBar( (int)(1000 * (float)(j-1) / (float)numberOfDats) ); //100% * dat we're on / total dats
						setStatusArea("Step " + lexical_cast<std::string>(j) + '/' + lexical_cast<std::string>(numberOfDats)+ ": Importing " +  dir_itr->path().filename() + " ");

						system(importCommand.c_str());
						//Sleep(1000);
						//cout << importCommand << "\n";
						j++;

					}
				}
				catch ( const std::exception & ex )
				{

					remove("Install.log");
					ofstream logfile("Install.log");


					logfile << "Warning, exception " << ex.what() << "!";
					setStatusArea("Warning, exception " + (string)ex.what() + "!");
					logfile.close();	
				}
			}

		}
		catch( const std::exception & ex ) {

			remove("Install.log");
			ofstream logfile("Install.log");


			logfile << "Warning, exception " << ex.what() << "!";
			setStatusArea("Warning, exception " + (string)ex.what() + "!");
			logfile.close();
		}

	}
	else if(splitInstances == NOT_SPLIT){
		directory_iterator end_iter;

		for ( directory_iterator dir_itr( vanilla_dir );
			dir_itr != end_iter;
			++dir_itr )
		{

			if ( is_directory( dir_itr->status() ) )
			{
				numberOfDats++;
			}


		}

		out << numberOfDats;
		datString = out.str();

		for ( directory_iterator dir_itr( vanilla_dir );
			dir_itr != end_iter;
			++dir_itr )
		{
			try
			{
				if ( is_directory( dir_itr->status() ) )
				{
					importCommand = strOniSplit + " " + strImportOption + " " + vanilla_dir.string() + dir_itr->path().filename() + " " + "../GameDataFolder/" + dir_itr->path().filename()
						+ ".dat";
					for (int i = 0; i < installedMods.size(); ++i) {
						if (exists("packages/" + installedMods[i] + "/oni/" + dir_itr->path().filename()  ))
							importCommand += " packages/" + installedMods[i] + "/oni/" + dir_itr->path().filename();
					}
					importCommand += " ../GameDataFolder/" + dir_itr->path().filename() + ".dat >> Install.log";


					setProgressBar( (int)(1000 * (float)(j-1) / (float)numberOfDats) ); //100% * dat we're on / total dats
					setStatusArea("Step " + lexical_cast<std::string>(j) + '/' + lexical_cast<std::string>(numberOfDats)+ ": Importing " +  dir_itr->path().filename() + " ");

					system(importCommand.c_str());

					j++;
				}
			}
			catch ( const std::exception & ex )
			{

				remove("Install.log");
				ofstream logfile("Install.log");


				logfile << "Warning, exception " << ex.what() << "!";
				setStatusArea("Warning, exception " + (string)ex.what() + "!");
				logfile.close();
			}}
	}
	logfile << "Writing config file";
	writeInstalledMods(installedMods);
	setProgressBar(1000);
	setStatusArea("Done! You can now play Oni.");

	ptime end_time(second_clock::local_time());
	time_period total_time (start_time, end_time);


	ofstream logfile2("Install.log", ios::app | ios::ate);
	string outstring = (string)"\n\nGlobalization ended " + to_simple_string(end_time) + "\nThe process took ";// + (string)total_time.length();

	logfile2 << "\nGlobalization ended " << to_simple_string(end_time) << "\nThe process took " << total_time.length();

	//logfile2.write(outstring.c_str(), outstring.length());
	logfile2.close();

	//total_time.length().hours();

	Sleep(1000);
	setProgressBar(0);
	busy = 0;
}

void writeInstalledMods(vector<string> installedMods)
{

	if ( exists( strInstallCfg ) )
	{
		remove( strInstallCfg );
	}

	ofstream file(strInstallCfg.c_str());

	vector<string>list = installedMods;
	vector<string>::iterator begin_iter = list.begin(); 
	vector<string>::iterator end_iter = list.end();

	sort( list.begin(), list.end() );

	for( ; begin_iter != end_iter; ++begin_iter) {
		file << *begin_iter << " ";
	}

	file.close();
	file.clear();

}

vector<string> getInstallString(string Cfg)
{
	//system(strPauseCmd);
	vector<string> returnval;

	string line;
	fstream file;

	if (exists( Cfg ))
	{
		file.open(Cfg.c_str());
		getline(file, line);
		tokenize(line, returnval);
		file.close();
		file.clear();
		sort(returnval.begin(), returnval.end());
	}
	else cout << "fail";

	return returnval;
}

//stolen token function...
void tokenize(const string& str, vector<string>& tokens, const string& delimiters)
{
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(delimiters, 0);
	// Find first "non-delimiter".
	string::size_type pos     = str.find_first_of(delimiters, lastPos);

	while (string::npos != pos || string::npos != lastPos)
	{
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = str.find_first_not_of(delimiters, pos);
		// Find next "non-delimiter"
		pos = str.find_first_of(delimiters, lastPos);
	}
}

void clearOldDats(void) {
	directory_iterator end_iter_gdf;
	for ( directory_iterator dir_itr_gdf( "../GameDataFolder" );
		dir_itr_gdf != end_iter_gdf;
		++dir_itr_gdf )
	{
		//cout << dir_itr_gdf->path().extension() << "\n";
		if ( dir_itr_gdf->path().extension() == ".dat" || dir_itr_gdf->path().extension() == ".raw" || dir_itr_gdf->path().extension() == ".sep" ) {
			remove( dir_itr_gdf->path() );
		}

	}

}

vector<string> globalInstalledMods;
vector<ModPackage> globalPackages;
#include "boost/thread.hpp"
#include <boost/thread/mutex.hpp>

/////////////////////////////////////////////////////////////////////////////
// Name:        main_window.cpp
// Purpose:     
// Author:      
// Modified by: 
// Created:     07/05/2009 20:38:25
// RCS-ID:      
// Copyright:   
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
#include "about_window.h"
////@end includes

#include "main_window.h"

////@begin XPM images
#include "redo.xpm"
#include "fileopen.xpm"
#include "filesaveas.xpm"
#include "quit.xpm"
////@end XPM images

//#define wxDebug 1;
//#define wxUSE_UNICODE 1;

/*
* MainWindow type definition
*/

IMPLEMENT_CLASS( MainWindow, wxFrame )


/*
* MainWindow event table definition
*/

BEGIN_EVENT_TABLE( MainWindow, wxFrame )

////@begin MainWindow event table entries
EVT_CHECKBOX( SelectAll_Checkbox, MainWindow::OnSelectAllCheckboxClick )

EVT_BUTTON( Refresh_Button, MainWindow::OnRefreshButtonClick )

EVT_LISTBOX( Mods_CheckboxList1, MainWindow::OnModsCheckboxList1Selected )
EVT_CHECKLISTBOX( Mods_CheckboxList1, MainWindow::OnModsCheckboxList1Toggled )

EVT_UPDATE_UI( ID_STATUSBAR, MainWindow::OnStatusbarUpdate )

EVT_BUTTON( Install_Button, MainWindow::OnInstallButtonClick )

EVT_RADIOBUTTON( Sep_RadioButton, MainWindow::OnSepRadioButtonSelected )

EVT_RADIOBUTTON( NoSep_RadioButton, MainWindow::OnNoSepRadioButtonSelected )

EVT_RADIOBUTTON( Separated_RadioButton, MainWindow::OnSeparatedRadioButtonSelected )

EVT_RADIOBUTTON( Complete_RadioButton, MainWindow::OnCompleteRadioButtonSelected )

EVT_BUTTON( ReGlobalize_Button, MainWindow::OnReGlobalizeButtonClick )

EVT_MENU( wxID_LOAD, MainWindow::OnLoadClick )

EVT_MENU( wxID_SAVE, MainWindow::OnSaveClick )

EVT_MENU( wxID_EXIT, MainWindow::OnExitClick )

EVT_MENU( wxID_OPTIONS, MainWindow::OnOptionsClick )

EVT_MENU( wxID_ABOUT, MainWindow::OnAboutClick )

////@end MainWindow event table entries

END_EVENT_TABLE()


/*
* MainWindow constructors
*/

MainWindow::MainWindow()
{
	Init();
}

MainWindow::MainWindow( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	Init();
	Create( parent, id, caption, pos, size, style );
}


/*
* MainWindow creator
*/

bool MainWindow::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	////@begin MainWindow creation
	wxFrame::Create( parent, id, caption, pos, size, style );

	CreateControls();
	SetIcon(GetIconResource(wxT("oni_special.ico")));
	Centre();


	////@end MainWindow creation
	return true;
}


/*
* MainWindow destructor
*/

MainWindow::~MainWindow()
{
	////@begin MainWindow destruction
	////@end MainWindow destruction
}


/*
* Member initialisation
*/

void MainWindow::Init()
{
	////@begin MainWindow member initialisation
	MainSplitter = NULL;
	SelectAll = NULL;
	RefreshButton = NULL;
	Mods_CheckboxList = NULL;
	titleText = NULL;
	creatorText = NULL;
	descriptionText = NULL;
	StatusArea = NULL;
	ProgressBar = NULL;
	InstallButton = NULL;
	OptionsPanel = NULL;
	SepRadio = NULL;
	NoSepRadio = NULL;
	SeparatedRadio = NULL;
	CompleteRadio = NULL;
	ReglobalizeButton = NULL;
	////@end MainWindow member initialisation

}


/*
* Control creation for MainWindow
*/
wxStatusBar **TheStatusBar;
wxButton* TheInstallButton;
wxGauge* TheProgressBar;
void MainWindow::CreateControls()
{    
	////@begin MainWindow content construction
	// Generated by DialogBlocks, 31/05/2009 19:03:55 (unregistered)

	MainWindow* itemFrame1 = this;

	wxMenuBar* menuBar = new wxMenuBar;
	wxMenu* itemMenu37 = new wxMenu;
	{
		wxMenuItem* menuItem = new wxMenuItem(itemMenu37, wxID_LOAD, _("&Load Configuration..."), wxEmptyString, wxITEM_NORMAL);
		wxBitmap bitmap(itemFrame1->GetBitmapResource(wxT("fileopen.xpm")));
		menuItem->SetBitmap(bitmap);
		itemMenu37->Append(menuItem);
	}
	{
		wxMenuItem* menuItem = new wxMenuItem(itemMenu37, wxID_SAVE, _("&Save Configuration..."), wxEmptyString, wxITEM_NORMAL);
		wxBitmap bitmap(itemFrame1->GetBitmapResource(wxT("filesaveas.xpm")));
		menuItem->SetBitmap(bitmap);
		itemMenu37->Append(menuItem);
	}
	itemMenu37->AppendSeparator();
	{
		wxMenuItem* menuItem = new wxMenuItem(itemMenu37, wxID_EXIT, _("Exit"), wxEmptyString, wxITEM_NORMAL);
		wxBitmap bitmap(itemFrame1->GetBitmapResource(wxT("quit.xpm")));
		menuItem->SetBitmap(bitmap);
		itemMenu37->Append(menuItem);
	}
	menuBar->Append(itemMenu37, _("&File"));
	wxMenu* itemMenu42 = new wxMenu;
	itemMenu42->Append(wxID_OPTIONS, _("Show Advanced Options..."), wxEmptyString, wxITEM_CHECK);
	menuBar->Append(itemMenu42, _("Options"));
	wxMenu* itemMenu44 = new wxMenu;
	itemMenu44->Append(wxID_HELP, _("Help"), wxEmptyString, wxITEM_NORMAL);
	itemMenu44->Append(wxID_ABOUT, _("About"), wxEmptyString, wxITEM_NORMAL);
	menuBar->Append(itemMenu44, _("Help"));
	itemFrame1->SetMenuBar(menuBar);
	
	wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
	itemFrame1->SetSizer(itemBoxSizer2);

	MainSplitter = new wxSplitterWindow( itemFrame1, ID_SPLITTERWINDOW, wxDefaultPosition, wxSize(100, 100), wxSP_LIVE_UPDATE|wxNO_BORDER );
	MainSplitter->SetMinimumPaneSize(150);
	MainSplitter->SetName(_T("MainSplitter"));

	wxPanel* itemPanel4 = new wxPanel( MainSplitter, ID_PANEL, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	wxBoxSizer* itemBoxSizer5 = new wxBoxSizer(wxVERTICAL);
	itemPanel4->SetSizer(itemBoxSizer5);

	wxBoxSizer* itemBoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer5->Add(itemBoxSizer6, 0, wxGROW|wxALL, 0);
	SelectAll = new wxCheckBox( itemPanel4, SelectAll_Checkbox, _("Select All/None"), wxDefaultPosition, wxDefaultSize, wxCHK_3STATE );
	SelectAll->SetValue(false);
	SelectAll->SetName(_T("SelectAll_Checkbox"));
	itemBoxSizer6->Add(SelectAll, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	RefreshButton = new wxBitmapButton( itemPanel4, Refresh_Button, itemFrame1->GetBitmapResource(wxT("redo.xpm")), wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW );
	RefreshButton->SetName(_T("RefreshButton"));
	itemBoxSizer6->Add(RefreshButton, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxTOP|wxBOTTOM, 5);

	wxArrayString Mods_CheckboxListStrings;
	Mods_CheckboxList = new wxCheckListBox( itemPanel4, Mods_CheckboxList1, wxDefaultPosition, wxDefaultSize, Mods_CheckboxListStrings, wxLB_HSCROLL );
	Mods_CheckboxList->SetName(_T("Mods_CheckboxList"));
	itemBoxSizer5->Add(Mods_CheckboxList, 1, wxGROW|wxALL, 0);

	wxPanel* itemPanel10 = new wxPanel( MainSplitter, DescriptionHolder_Panel, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	itemPanel10->SetName(_T("DescriptionHolder_Panel"));
	wxBoxSizer* itemBoxSizer11 = new wxBoxSizer(wxVERTICAL);
	itemPanel10->SetSizer(itemBoxSizer11);

	wxBoxSizer* itemBoxSizer12 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer11->Add(itemBoxSizer12, 0, wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer13 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer12->Add(itemBoxSizer13, 1, wxALIGN_CENTER_VERTICAL|wxALL, 0);
	titleText = new wxTextCtrl( itemPanel10, Title_Text, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_READONLY );
	titleText->SetName(_T("Title_Text"));
	titleText->SetBackgroundColour(wxColour(240, 240, 240));
	itemBoxSizer13->Add(titleText, 1, wxGROW|wxLEFT, 5);

	wxBoxSizer* itemBoxSizer15 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer12->Add(itemBoxSizer15, 1, wxGROW|wxALL, 0);
	creatorText = new wxTextCtrl( itemPanel10, Author_Text, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_READONLY|wxTE_RIGHT );
	creatorText->SetName(_T("Author_Text"));
	creatorText->SetBackgroundColour(wxColour(240, 240, 240));
	itemBoxSizer15->Add(creatorText, 1, wxGROW|wxRIGHT, 5);

	wxStaticLine* itemStaticLine17 = new wxStaticLine( itemPanel10, wxID_STATIC, wxDefaultPosition, wxDefaultSize, wxLI_HORIZONTAL );
	itemStaticLine17->Show(false);
	itemBoxSizer11->Add(itemStaticLine17, 0, wxGROW|wxALL, 5);

	descriptionText = new wxTextCtrl( itemPanel10, Description_Text, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxTE_READONLY|wxTE_RICH|wxTE_AUTO_URL );
	descriptionText->SetName(_T("DescriptionName"));
	descriptionText->SetBackgroundColour(wxColour(240, 240, 240));
	itemBoxSizer11->Add(descriptionText, 1, wxGROW|wxLEFT|wxRIGHT, 5);

	MainSplitter->SplitVertically(itemPanel4, itemPanel10, 150);
	itemBoxSizer2->Add(MainSplitter, 1, wxGROW|wxALL, 0);

	StatusArea = new wxStatusBar( itemFrame1, ID_STATUSBAR, 0 );
	StatusArea->SetName(_T("StatusArea"));
	StatusArea->SetFieldsCount(1);
	StatusArea->SetStatusText(_("Status Area"), 0);
	itemBoxSizer2->Add(StatusArea, 0, wxGROW|wxALL, 0);

	wxBoxSizer* itemBoxSizer20 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer2->Add(itemBoxSizer20, 0, wxGROW|wxALL, 0);

	ProgressBar = new wxGauge( itemFrame1, ProgressBar_Gauge, 1000, wxDefaultPosition, wxSize(-1, 30), wxGA_SMOOTH );
	ProgressBar->SetValue(0);
	itemBoxSizer20->Add(ProgressBar, 1, wxGROW|wxALL, 0);

	InstallButton = new wxButton( itemFrame1, Install_Button, _("Install!"), wxDefaultPosition, wxSize(-1, 30), 0 );
	itemBoxSizer20->Add(InstallButton, 0, wxGROW|wxALL, 0);

	wxBoxSizer* itemBoxSizer23 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer2->Add(itemBoxSizer23, 0, wxGROW|wxALL, 0);

	OptionsPanel = new wxPanel( itemFrame1, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	itemBoxSizer2->Add(OptionsPanel, 0, wxGROW, 0);

	wxBoxSizer* itemBoxSizer25 = new wxBoxSizer(wxHORIZONTAL);
	OptionsPanel->SetSizer(itemBoxSizer25);

	wxBoxSizer* itemBoxSizer26 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer25->Add(itemBoxSizer26, 0, wxGROW|wxALL, 5);

	SepRadio = new wxRadioButton( OptionsPanel, Sep_RadioButton, _("Sep"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP );
	SepRadio->SetValue(false);
	if (MainWindow::ShowToolTips())
		SepRadio->SetToolTip(_("For PC Demo and Mac"));
	itemBoxSizer26->Add(SepRadio, 0, wxALIGN_LEFT|wxALL, 5);

	NoSepRadio = new wxRadioButton( OptionsPanel, NoSep_RadioButton, _("NoSep"), wxDefaultPosition, wxDefaultSize, 0 );
	NoSepRadio->SetValue(false);
	if (MainWindow::ShowToolTips())
		NoSepRadio->SetToolTip(_("For PC Retail"));
	itemBoxSizer26->Add(NoSepRadio, 0, wxALIGN_LEFT|wxALL, 5);

	wxStaticLine* itemStaticLine29 = new wxStaticLine( OptionsPanel, wxID_STATIC, wxDefaultPosition, wxDefaultSize, wxLI_VERTICAL );
	itemBoxSizer25->Add(itemStaticLine29, 0, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer30 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer25->Add(itemBoxSizer30, 0, wxGROW|wxALL, 5);

	SeparatedRadio = new wxRadioButton( OptionsPanel, Separated_RadioButton, _("Separated Level0"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP );
	SeparatedRadio->SetValue(false);
	SeparatedRadio->SetName(_T("Separated_RadioButton"));
	itemBoxSizer30->Add(SeparatedRadio, 0, wxALIGN_LEFT|wxALL, 5);

	CompleteRadio = new wxRadioButton( OptionsPanel, Complete_RadioButton, _("Complete Level0"), wxDefaultPosition, wxDefaultSize, 0 );
	CompleteRadio->SetValue(false);
	CompleteRadio->SetName(_T("Complete_RadioButton"));
	itemBoxSizer30->Add(CompleteRadio, 0, wxALIGN_LEFT|wxALL, 5);

	wxStaticLine* itemStaticLine33 = new wxStaticLine( OptionsPanel, wxID_STATIC, wxDefaultPosition, wxDefaultSize, wxLI_VERTICAL );
	itemBoxSizer25->Add(itemStaticLine33, 0, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer34 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer25->Add(itemBoxSizer34, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	ReglobalizeButton = new wxButton( OptionsPanel, ReGlobalize_Button, _("Reglobalize"), wxDefaultPosition, wxDefaultSize, 0 );
	ReglobalizeButton->SetName(_T("Reglobalize_Button"));
	itemBoxSizer34->Add(ReglobalizeButton, 0, wxGROW|wxALL, 5);

	// Connect events and objects
	Mods_CheckboxList->Connect(Mods_CheckboxList1, wxEVT_CREATE, wxWindowCreateEventHandler(MainWindow::ModList_OnCreate), NULL, this);
	////@end MainWindow content construction

	if ( exists( "../../GameDataFolder/level0_Final.sep" ) ) {
		static_cast<string>("-import:sep");
		splitInstances = NOT_SPLIT;
	}
	else {
		static_cast<string>("-import:nosep");
		splitInstances = SPLIT;
	}

	globalPackages = getPackages();
	globalInstalledMods = getInstallString();
	for (int i = 0; i < globalPackages.size(); i++) {
		Mods_CheckboxList->Append(globalPackages[i].name.c_str());
		if( binary_search(globalInstalledMods.begin(), globalInstalledMods.end(), globalPackages[i].modStringName ) ) Mods_CheckboxList->Check(i);
	}

	TheStatusBar = &StatusArea;
	TheInstallButton = InstallButton;
	TheProgressBar = ProgressBar;
	OptionsPanel->Hide();
	if(splitInstances == SPLIT) SeparatedRadio->SetValue(true);
	else CompleteRadio->SetValue(true);



	if(strImportOption == "-import:nosep") NoSepRadio->SetValue(true);
	else SepRadio->SetValue(true);


#ifdef WIN32
	RedirectIOToConsole(); 
	HWND hWnd = GetConsoleWindow(); 
	ShowWindow( hWnd, SW_HIDE ); 
#endif

	//MainWindow::SetSize(MainWindow::GetRect().GetWidth(), MainWindow::GetRect().GetHeight()-OptionsPanel->GetRect().GetHeight() );
}


/*
* wxEVT_COMMAND_CHECKBOX_CLICKED event handler for SelectAll_Checkbox
*/

void MainWindow::OnSelectAllCheckboxClick( wxCommandEvent& event )
{
	switch(SelectAll->Get3StateValue()) {
	case wxCHK_UNCHECKED:
		for(int i = 0; i < globalPackages.size(); i++) Mods_CheckboxList->Check(i, false);
		//SelectAll->Set3StateValue(wxCHK_CHECKED);
		break;
	case wxCHK_CHECKED:
		for(int i = 0; i < globalPackages.size(); i++) Mods_CheckboxList->Check(i, true);
		//SelectAll->Set3StateValue(wxCHK_UNCHECKED);
		break;
	case wxCHK_UNDETERMINED:
		for(int i = 0; i < globalPackages.size(); i++) Mods_CheckboxList->Check(i, false);
		//SelectAll->Set3StateValue(wxCHK_CHECKED);
		break;

	}

}


/*
* wxEVT_CREATE event handler for Mods_CheckboxList
*/

void MainWindow::ModList_OnCreate( wxWindowCreateEvent& event )
{


}


/*
* Should we show tooltips?
*/

bool MainWindow::ShowToolTips()
{
	return true;
}

/*
* Get bitmap resources
*/

wxBitmap MainWindow::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
	////@begin MainWindow bitmap retrieval
	wxUnusedVar(name);
	if (name == _T("redo.xpm"))
	{
		wxBitmap bitmap(redo_xpm);
		return bitmap;
	}
	else if (name == _T("fileopen.xpm"))
	{
		wxBitmap bitmap( fileopen_xpm);
		return bitmap;
	}
	else if (name == _T("filesaveas.xpm"))
	{
		wxBitmap bitmap( filesaveas_xpm);
		return bitmap;
	}
	else if (name == _T("quit.xpm"))
	{
		wxBitmap bitmap( quit_xpm);
		return bitmap;
	}
	return wxNullBitmap;
	////@end MainWindow bitmap retrieval
}

/*
* Get icon resources
*/

wxIcon MainWindow::GetIconResource( const wxString& name )
{

	// Icon retrieval
	////@begin MainWindow icon retrieval
	wxUnusedVar(name);
	if (name == _T("oni_special.ico"))
	{
		//	wxIcon icon(_T("oni_special.ico"), wxBITMAP_TYPE_ICO);
		//	return icon;
	}
	return wxNullIcon;
	////@end MainWindow icon retrieval
}


/*
* wxEVT_COMMAND_LISTBOX_SELECTED event handler for Mods_CheckboxList1
*/

void MainWindow::OnModsCheckboxList1Selected( wxCommandEvent& event )
{
	//event.GetSelection
	titleText->SetValue(globalPackages[event.GetSelection()].name.c_str());
	creatorText->SetValue(globalPackages[event.GetSelection()].creator.c_str());
	descriptionText->SetValue(globalPackages[event.GetSelection()].readme.c_str());

	//creatorText->Refresh();
}


/*
* wxEVT_COMMAND_CHECKLISTBOX_TOGGLED event handler for Mods_CheckboxList1
*/

void MainWindow::OnModsCheckboxList1Toggled( wxCommandEvent& event )
{
	SelectAll->Set3StateValue(wxCHK_UNDETERMINED);
	if(event.GetInt()) {
		/*
		switch(SelectAll->Get3StateValue()) {
		case wxCHK_UNCHECKED:
		break;
		case wxCHK_CHECKED:
		break;
		case wxCHK_UNDETERMINED :
		break;
		}
		*/
	}
}


/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_OPTIONS
*/

void MainWindow::OnOptionsClick( wxCommandEvent& event )
{




	if (!event.GetInt() ) {
		OptionsPanel->Hide(); 
		this->SetSize(this->GetRect().GetWidth(), this->GetRect().GetHeight()-OptionsPanel->GetRect().GetHeight());}
	else {
//		Uncomment this when we release, it gets annoying if you are testing globalization a lot ;)
		wxMessageDialog* YesNoDialog = new wxMessageDialog(this, 			"WARNING: These options are for advanced users only, use with caution.", "AE Installer Alert",  wxOK | wxICON_EXCLAMATION	, wxDefaultPosition);
		YesNoDialog->ShowModal();
		OptionsPanel->Show();
		this->SetSize(this->GetRect().GetWidth(), this->GetRect().GetHeight()+OptionsPanel->GetRect().GetHeight());
	}
	
}


/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_EXIT
*/

void MainWindow::OnExitClick( wxCommandEvent& event )
{
	exit(0);
}


/*
* wxEVT_COMMAND_BUTTON_CLICKED event handler for Install_Button
*/


struct recompile
{
	recompile(vector<string> localPackages) : thePackages(localPackages) { }
	void operator()()
	{
		TheInstallButton->Disable();
		recompileAll(thePackages);
		TheInstallButton->Enable();
	}

	vector<string> thePackages;
};

void MainWindow::OnInstallButtonClick( wxCommandEvent& event )
{

	vector<string> localPackages;
	localPackages.push_back("Globalize");
	for(int i = 0; i < globalPackages.size(); i++) if(Mods_CheckboxList->IsChecked(i)) localPackages.push_back( globalPackages[i].modStringName );
	if ( !localPackages.empty() )	{
	
		//MainWindow::MainWindow().Hide();	
		//	boost::thread thrd2(recompileAll(localPackages) );
		//MainWindow::MainWindow().Show();
		this->InstallButton->Disable();
		this->ReglobalizeButton->Disable();
#ifdef WIN32
		recompile packages(localPackages);
		boost::thread thrd(packages);
#else
		recompileAll(localPackages);
#endif

		this->InstallButton->Enable();
		this->ReglobalizeButton->Enable();
	}


}

/*void setStatusArea( string s ) {
//TheStatusBar = MainWindow::StatusArea;
(**TheStatusBar).SetStatusText(_(s.c_str()), 0);

//MainWindow::MainWindow().SetSize(MainWindow::MainWindow().GetRect().GetWidth(), MainWindow::MainWindow().GetRect().GetHeight()+1);

//MainWindow::StatusBar->SetLabel("Importing Files...");
//StatusBar->SetLabel(s);
//->SetLabel(s);

}*/

void setProgressBar( int i ) {
	//TheProgressBar->SetValue(

	TheProgressBar->SetValue(i);

}


/*
* wxEVT_UPDATE_UI event handler for ID_STATUSBAR
*/

void MainWindow::OnStatusbarUpdate( wxUpdateUIEvent& event )
{
	////@begin wxEVT_UPDATE_UI event handler for ID_STATUSBAR in MainWindow.
	// Before editing this code, remove the block markers.
	event.Skip();
	////@end wxEVT_UPDATE_UI event handler for ID_STATUSBAR in MainWindow. 
}


/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_ABOUT
*/

void MainWindow::OnAboutClick( wxCommandEvent& event )
{
	////@begin wxEVT_COMMAND_MENU_SELECTED event handler for wxID_ABOUT in MainWindow.
	// Before editing this code, remove the block markers.
	About* window = new About(this);
	int returnValue = window->ShowModal();
	window->Destroy();
	////@end wxEVT_COMMAND_MENU_SELECTED event handler for wxID_ABOUT in MainWindow. 
}


/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for NoSep_RadioButton
*/

void MainWindow::OnNoSepRadioButtonSelected( wxCommandEvent& event )
{
	static_cast<string>("-import:nosep");
}


/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Sep_RadioButton
*/

void MainWindow::OnSepRadioButtonSelected( wxCommandEvent& event )
{
	static_cast<string>("-import:sep");
}


/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Separated_RadioButton
*/

void MainWindow::OnSeparatedRadioButtonSelected( wxCommandEvent& event )
{
	splitInstances = SPLIT;

}


/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Complete_RadioButton
*/

void MainWindow::OnCompleteRadioButtonSelected( wxCommandEvent& event )
{
	splitInstances = NOT_SPLIT;

}


/*
* wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BITMAPBUTTON
*/

void MainWindow::OnRefreshButtonClick( wxCommandEvent& event )
{
	refreshMods(globalInstalledMods);
}


/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_LOAD
*/




void MainWindow::refreshMods (vector<string> s) {

	Mods_CheckboxList->Clear();
	//globalInstalledMods = getPackages();
	for (int i = 0; i < globalPackages.size(); i++) {
		Mods_CheckboxList->Append(globalPackages[i].name.c_str());
		if( binary_search(s.begin(), s.end(), globalPackages[i].modStringName ) ) Mods_CheckboxList->Check(i);
		//else Mods_CheckboxList->Check(i,0);

	}
}

void MainWindow::OnLoadClick( wxCommandEvent& event )
{
	if (busy == 1) return;
	static const wxChar *FILETYPES = _T(
		"Mod Loadouts (*.cfg)|*.cfg|"
		"All files (*.*)|*.*"
		);

	wxFileDialog* openFileDialog =
		new wxFileDialog( this, _("Open Mod Loadout"), "", "", FILETYPES,
		wxOPEN, wxDefaultPosition);

	if ( openFileDialog->ShowModal() == wxID_OK )
	{
		refreshMods(getInstallString( string(openFileDialog->GetPath()) ));
	}


}


/*
* wxEVT_COMMAND_MENU_SELECTED event handler for wxID_SAVE
*/

void MainWindow::OnSaveClick( wxCommandEvent& event )
{
	if (busy == 1) return;
	static const wxChar *FILETYPES = _T(
		"Mod Loadouts (*.cfg)|*.cfg|"
		"All files (*.*)|*.*"
		);

	wxFileDialog* openFileDialog =
		new wxFileDialog( this, _("Open file"), "", "", FILETYPES,
		wxSAVE, wxDefaultPosition);

	if ( openFileDialog->ShowModal() == wxID_OK )
	{


		//Mods_CheckboxList->



		//

		if ( exists( openFileDialog->GetPath().c_str() ) )
		{
			remove( openFileDialog->GetPath().c_str() );
		}

		ofstream file(openFileDialog->GetPath().c_str());

		vector<string>list;
		for(int i = 0; i < globalPackages.size(); i++) if(Mods_CheckboxList->IsChecked(i)) list.push_back( globalPackages[i].modStringName );
		vector<string>::iterator begin_iter = list.begin(); 
		vector<string>::iterator end_iter = list.end();

		sort( list.begin(), list.end() );

		for( ; begin_iter != end_iter; ++begin_iter) {
			file << *begin_iter << " ";
		}

		file.close();
		file.clear();

		//SetCurrentFilename(openFileDialog->GetFilename());
		//theText->LoadFile(openFileDialog->GetFilename());
		//SetStatusText(GetCurrentFilename(), 0);
		//SetStatusText(openFileDialog->GetDirectory(),1);
	}
}



/*
* wxEVT_COMMAND_BUTTON_CLICKED event handler for ReGlobalize_Button
*/

void MainWindow::OnReGlobalizeButtonClick( wxCommandEvent& event )
{
	wxMessageDialog* YesNoDialog = new wxMessageDialog(this, 			"WARNING: This will DELETE the Edition's GameDataFolder and reglobalize all of your data. \n Are you SURE you want to do this? ", "AE Installer Alert",  wxYES_NO | wxICON_EXCLAMATION	, wxDefaultPosition);

	if (YesNoDialog->ShowModal() == wxID_NO) { //if the user said no...

	}
	else {
	
		this->InstallButton->Disable();
		this->ReglobalizeButton->Disable();

#ifdef WIN32

		boost::thread thrd2(globalizeData);
		//globalizeData();
		//boost::thread::create_thread(&globalizeData);
		//	 boost::thread_group Tg;
		// Tg.create_thread( &globalizeData(), this );
#else
		globalizeData();
#endif
		
		this->InstallButton->Enable();
		this->ReglobalizeButton->Enable();
	}

}
/*
* wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Separated_RadioButton
*/

/*void MainWindow::OnSeparatedRadioButtonSelected( wxCommandEvent& event )
{
////@begin wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Separated_RadioButton in MainWindow.
// Before editing this code, remove the block markers.
event.Skip();
////@end wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Separated_RadioButton in MainWindow. 
}*/

