#include "Daodan_BSL.h"
#include "BFW_ScriptingLanguage.h"

uint16_t ONICALL bsl_int32mul(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	ret->value_int32 = args[0].value_int32 * args[1].value_int32;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_mul(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	
	double val1;
	double val2;
	
	if (args[0].type == sl_int32)
		val1 = args[0].value_int32;
	else
		val1 = args[0].value_float;
	
	if (args[1].type == sl_int32)
		val2 = args[1].value_int32;
	else
		val2 = args[1].value_float;
	
	ret->value_float = (float)(val1 * val2);
	ret->type = sl_float;
	return 0;
}

uint16_t ONICALL bsl_int32div(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	ret->value_int32 = args[0].value_int32 / args[1].value_int32;
	ret->type = sl_int32;
	return 0;
}

uint16_t ONICALL bsl_div(void* dontuse0, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret)
{
	if (numargs < 2)
		return 1;
	
	double val1;
	double val2;
	
	if (args[0].type == sl_int32)
		val1 = args[0].value_int32;
	else
		val1 = args[0].value_float;
	
	if (args[1].type == sl_int32)
		val2 = args[1].value_int32;
	else
		val2 = args[1].value_float;
	
	ret->value_float = (float)(val1 / val2);
	ret->type = sl_float;
	return 0;
}

void SLrDaodan_Initalize()
{
	SLrScript_Command_Register_ReturnType("int32mul", "Multiplies two numbers", "n1:int n2:int", sl_int32, bsl_int32mul);
	SLrScript_Command_Register_ReturnType("mul", "Multiplies two numbers", "[int1:int|float1:float] [int2:int|float2:float]", sl_float, bsl_mul);
	
	SLrScript_Command_Register_ReturnType("int32div", "Divides two numbers", "n1:int n2:int", sl_int32, bsl_int32div);
	SLrScript_Command_Register_ReturnType("div", "Divides two numbers", "[int1:int|float1:float] [int2:int|float2:float]", sl_float, bsl_div);
}
