#pragma once
#ifndef BFW_UTILITY_H
#define BFW_UTILITY_H

#include "Daodan.h"

#include <stdint.h>
#include <stdbool.h>

typedef enum {
	sl_int32,
	sl_str32, /* it's fixed length, 32 bytes. */
	sl_float,
	sl_bool,  /* Actually int32 0 or 1. */
	sl_void,
} sl_type;

typedef struct {
	sl_type type;
	union {
		void*   value;
		int32_t value_int32;
		char*   value_str32;
		float   value_float;
		bool    value_bool;
	};
} sl_arg;

typedef struct {
	char*    name;
	char*    calllocation; //maybe
} sl_callinfo;

typedef uint16_t (ONICALL *sl_func)(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], void* dontuse1, void* dontuse2, sl_arg* ret);

uint16_t ONICALL SLrScript_Command_Register_ReturnType(char* name, char* desc, char* argfmt, sl_type type, sl_func callback);
uint16_t ONICALL SLrScript_Command_Register_Void(char* name, char* desc, char* argfmt, sl_func callback);
uint16_t ONICALL SLrGlobalVariable_Register_Int32(char* name, char* desc, int32_t* data);
uint16_t ONICALL SLrGlobalVariable_Register_Float(char* name, char* desc, float* data);
uint16_t ONICALL SLrGlobalVariable_Register_Bool(char* name, char* desc, uint32_t* data);
uint16_t ONICALL SLrGlobalVariable_Register_String(char* name, char* desc, char* data);

#endif
