#include <stdlib.h>
#include <stdarg.h>
#include <stdint.h>

#include "Daodan_Console.h"
#include "BFW_Utility.h"

void DDrConsole_Print(const char* text)
{
	COrTextArea_Print(COgConsoleLines, 1, COgDefaultTextShade, COgDefaultTextShadow, text, 0, COgFadeTimeValue);
}

void DDrConsole_PrintColored(const char* text, int priority, RGBA color, RGBA shade)
{
	int* intcolor = (int*)&color;
	int* intshade = (int*)&shade;
	COrTextArea_Print(COgConsoleLines, 1, *intcolor, *intshade, text, 0, COgFadeTimeValue);
}

void DDrConsole_PrintF(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	char* buffer = malloc(vsnprintf(NULL, 0, fmt, ap) + 1);
	
	vsprintf(buffer, fmt, ap);
	va_end(ap);

	DDrConsole_Print(buffer);
	free(buffer);
	return;
}
