//for IDirectSound we need
//#include <dsound.h>
//http://ccrma.stanford.edu/software/stk/Misc/dsound.h

typedef struct {
	uint32_t Width;
	uint32_t Height;
	uint32_t FrameCount;
	uint32_t CurrentFrame;
	uint32_t LastFrame;
	uint32_t FPS_Multiplier;
	uint32_t FPS_Divisor;
	uint32_t Unknown1;
	uint32_t Flags;
	uint32_t Unknown2[65];
	uint32_t CurrentPlane;
	void*	 Plane0_Ptr;
	void*	 Plane1_Ptr;
	uint32_t Unknown3[2];
	uint32_t YPlane_Width;
	uint32_t UnVPlane_Width;
	uint32_t UnVPlane_Height;
} BinkStruct;

//_stdcall
	//opens the bink file
	BinkStruct CALLBACK *BinkOpen(HANDLE BinkFile, uint32_t Flags);
	
	//SoundFunction: This appears to be the function that will be invoked in order to playback the audio. 
	//MPC passes in BinkOpenDirectSound as the parameter. BinkOpenDirectSound must meet the qualifications to be a SOUND_FUNC 
	//(contrived for this description).
	//I renamed SOUND_FUNC to void*
	int CALLBACK BinkSetSoundSystem(void* SoundFunction, IDirectSound *pDS);
	
	//changes the frame the video is on...we dont need it.
	void CALLBACK BinkGoto(BinkStruct *Bink, uint32_t FrameNumber, uint32_t unknown);
	
	//processes the next frame in the Bink file.
	int CALLBACK BinkDoFrame(BinkStruct *Bink);

	//advance the playback engine to the next frame
	void CALLBACK BinkNextFrame(BinkStruct *Bink);

	//gracefully closes a Bink file and releases any allocated resources.
	void CALLBACK BinkClose(BinkStruct *Bink);

/*
bytes 0-3      video width
bytes 4-7      video height
bytes 8-11     frame count
bytes 12-15    current frame
bytes 16-19    last frame
bytes 20-23    frames/second multiplier
bytes 24-27    frames/second divisor
bytes 28-31    unknown
bytes 32-35    flags
bytes 36-295   unknown
bytes 296-299  current plane
bytes 300-303  pointer to plane 0
bytes 304-307  pointer to plane 1
bytes 308-315  unknown
bytes 316-319  Y plane width
bytes 320-323  Y plane height
bytes 324-327  U&V plane width
bytes 328-331  U&V plane height
*/