/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IPropertyList;
import org.javabuilders.Node;
import org.javabuilders.ValueListDefinition;
import org.javabuilders.Values;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.swing.SwingAction;
import org.javabuilders.util.BuilderUtils;

public class CommonActionListenerHandler
extends AbstractPropertyHandler
implements IPropertyList {
    private static final List<ValueListDefinition> defs = ValueListDefinition.getCommonEventDefinitions((Class[])new Class[]{ActionEvent.class});
    private static final CommonActionListenerHandler singleton = new CommonActionListenerHandler();

    public static CommonActionListenerHandler getInstance() {
        return singleton;
    }

    private CommonActionListenerHandler() {
        super(new String[]{"onAction"});
    }

    public void handle(BuilderConfig config, final BuildProcess process, final Node node, String key) throws BuildException {
        final Values values = (Values)node.getProperty(new String[]{key});
        if (values.size() > 0) {
            if (node.getMainObject() instanceof SwingAction) {
                SwingAction.IActionHandler handler = new SwingAction.IActionHandler(){

                    @Override
                    public void onAction(ActionEvent e) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)node.getMainObject(), (Collection)values.values(), (Object)e);
                    }
                };
                ((SwingAction)node.getMainObject()).setActionHandler(handler);
            } else {
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)node.getMainObject(), (Collection)values.values(), (Object)e);
                    }
                };
                if (node.getMainObject() instanceof AbstractButton) {
                    ((AbstractButton)node.getMainObject()).addActionListener(listener);
                } else if (node.getMainObject() instanceof JComboBox) {
                    ((JComboBox)node.getMainObject()).addActionListener(listener);
                } else if (node.getMainObject() instanceof JTextField) {
                    ((JTextField)node.getMainObject()).addActionListener(listener);
                }
            }
        }
    }

    public boolean isList(String propertyName) {
        return true;
    }

    public List<ValueListDefinition> getValueListDefinitions(String propertyName) {
        return defs;
    }
}

