/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.List;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IPropertyList;
import org.javabuilders.Node;
import org.javabuilders.ValueListDefinition;
import org.javabuilders.Values;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.BuilderUtils;

public class ComponentKeyListenerHandler
extends AbstractPropertyHandler
implements IPropertyList {
    private static final ComponentKeyListenerHandler singleton = new ComponentKeyListenerHandler();
    private static final List<ValueListDefinition> defs = ValueListDefinition.getCommonEventDefinitions((Class[])new Class[]{KeyEvent.class});

    public static ComponentKeyListenerHandler getInstance() {
        return singleton;
    }

    private ComponentKeyListenerHandler() {
        super(new String[]{"onKeyPressed", "onKeyReleased", "onKeyTyped"});
    }

    public void handle(BuilderConfig config, final BuildProcess process, final Node node, String key) throws BuildException {
        Component component = (Component)node.getMainObject();
        final Values onKeyTypedList = (Values)node.getProperty(new String[]{"onKeyTyped"});
        final Values onKeyReleasedList = (Values)node.getProperty(new String[]{"onKeyReleased"});
        final Values onKeyPressedList = (Values)node.getProperty(new String[]{"onKeyPressed"});
        component.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (onKeyPressedList != null && onKeyPressedList.size() > 0) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onKeyPressedList.values(), (Object)e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (onKeyReleasedList != null && onKeyReleasedList.size() > 0) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onKeyReleasedList.values(), (Object)e);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (onKeyTypedList != null && onKeyTypedList.size() > 0) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Node)node, (Collection)onKeyTypedList.values(), (Object)e);
                }
            }
        });
    }

    public Class<?> getApplicableClass() {
        return Component.class;
    }

    public boolean isList(String propertyName) {
        return true;
    }

    public List<ValueListDefinition> getValueListDefinitions(String propertyName) {
        return defs;
    }
}

