/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.event;

import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.util.Collection;
import java.util.List;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IPropertyList;
import org.javabuilders.Node;
import org.javabuilders.ValueListDefinition;
import org.javabuilders.Values;
import org.javabuilders.event.ObjectMethod;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.util.BuilderUtils;

public class WindowListenerHandler
extends AbstractPropertyHandler
implements IPropertyList {
    private static final List<ValueListDefinition> defs = ValueListDefinition.getCommonEventDefinitions((Class[])new Class[]{WindowEvent.class});
    private static final WindowListenerHandler singleton = new WindowListenerHandler();

    public static WindowListenerHandler getInstance() {
        return singleton;
    }

    protected WindowListenerHandler() {
        super(new String[]{"onStateChanged", "onWindowFocus", "onWindowFocusLost", "onWindowActivated", "onWindowClosed", "onWindowClosing", "onWindowDeactivated", "onWindowDeiconified", "onWindowIconified", "onWindowOpened"});
    }

    public void handle(BuilderConfig config, BuildProcess process, Node node, String key) throws BuildException {
        Values stateValues = (Values)node.getProperty(new String[]{"onStateChanged"});
        Values windowFocusValues = (Values)node.getProperty(new String[]{"onWindowFocus"});
        Values windowFocusLostValues = (Values)node.getProperty(new String[]{"onWindowFocusLost"});
        Values windowActivatedValues = (Values)node.getProperty(new String[]{"onWindowActivated"});
        Values windowClosedValues = (Values)node.getProperty(new String[]{"onWindowClosed"});
        Values windowClosingValues = (Values)node.getProperty(new String[]{"onWindowClosing"});
        Values windowDeactivatedValues = (Values)node.getProperty(new String[]{"onWindowDeactivated"});
        Values windowDeiconifiedValues = (Values)node.getProperty(new String[]{"onWindowDeiconified"});
        Values windowIconifiedValues = (Values)node.getProperty(new String[]{"onWindowIconified"});
        Values windowOpenedValues = (Values)node.getProperty(new String[]{"onWindowOpened"});
        this.createListeners(node, process, (Values<String, ObjectMethod>)stateValues, (Values<String, ObjectMethod>)windowFocusValues, (Values<String, ObjectMethod>)windowFocusLostValues, (Values<String, ObjectMethod>)windowActivatedValues, (Values<String, ObjectMethod>)windowClosedValues, (Values<String, ObjectMethod>)windowClosingValues, (Values<String, ObjectMethod>)windowDeactivatedValues, (Values<String, ObjectMethod>)windowDeiconifiedValues, (Values<String, ObjectMethod>)windowIconifiedValues, (Values<String, ObjectMethod>)windowOpenedValues);
    }

    protected void createListeners(Node node, final BuildProcess process, final Values<String, ObjectMethod> stateValues, final Values<String, ObjectMethod> windowFocusValues, final Values<String, ObjectMethod> windowFocusLostValues, final Values<String, ObjectMethod> windowActivatedValues, final Values<String, ObjectMethod> windowClosedValues, final Values<String, ObjectMethod> windowClosingValues, final Values<String, ObjectMethod> windowDeactivatedValues, final Values<String, ObjectMethod> windowDeiconifiedValues, final Values<String, ObjectMethod> windowIconifiedValues, final Values<String, ObjectMethod> windowOpenedValues) {
        final Window control = (Window)node.getMainObject();
        if (stateValues != null) {
            control.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)stateValues.values(), (Object)e);
                }
            });
        }
        if (BuilderUtils.isListenerNeeded((Values[])new Values[]{windowFocusValues, windowFocusLostValues})) {
            control.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    if (windowFocusValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowFocusValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (windowFocusLostValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowFocusLostValues.values(), (Object)e);
                    }
                }
            });
        }
        if (BuilderUtils.isListenerNeeded((Values[])new Values[]{windowActivatedValues, windowClosedValues, windowClosingValues, windowDeactivatedValues, windowDeiconifiedValues, windowIconifiedValues, windowOpenedValues})) {
            control.addWindowListener(new WindowListener(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (windowActivatedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowActivatedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    if (windowClosedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowClosedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    if (windowClosingValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowClosingValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    if (windowDeactivatedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowDeactivatedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    if (windowDeiconifiedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowDeiconifiedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    if (windowIconifiedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowIconifiedValues.values(), (Object)e);
                    }
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    if (windowOpenedValues != null) {
                        BuilderUtils.invokeCallerEventMethods((BuildResult)process.getBuildResult(), (Object)control, (Collection)windowOpenedValues.values(), (Object)e);
                    }
                }
            });
        }
    }

    public Class<?> getApplicableClass() {
        return Window.class;
    }

    public List<ValueListDefinition> getValueListDefinitions(String propertyName) {
        return defs;
    }

    public boolean isList(String propertyName) {
        return true;
    }
}

