/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type;

import java.awt.Color;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeAsValueHandler;
import org.javabuilders.swing.handler.type.ColorAsValueHandler;

public class BorderAsValueHandler
implements ITypeAsValueHandler<Border> {
    public static final String LOWERED_BEVEL = "loweredBevel";
    public static final String RAISED_BEVEL = "raisedBevel";
    public static final String LOWERED_ETCHED = "loweredEtched";
    public static final String RAISED_ETCHED = "raisedEtched";
    public static final String LINE_BORDER_REGEX = "\\d+";
    public static final String COLOR_LINE_BORDER_REGEX = "^([a-zA-Z0-9]+)\\s+\\d+$";
    private static final String regex = MessageFormat.format("{0}|{1}|{2}|{3}|{4}|({5})|{6}", "loweredBevel", "raisedBevel", "loweredEtched", "raisedEtched", "\\d+", "^[a-zA-Z]*$|^([a-fA-F0-9]){6}$|^([a-fA-F0-9]){3}$", "^([a-zA-Z0-9]+)\\s+\\d+$");
    private static final BorderAsValueHandler singleton = new BorderAsValueHandler();

    public static BorderAsValueHandler getInstance() {
        return singleton;
    }

    private BorderAsValueHandler() {
    }

    public String getInputValueSample() {
        return "olive 3 | 3 | raisedEtched | loweredBevel";
    }

    public String getRegex() {
        return regex;
    }

    public Border getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        Border border = null;
        if (RAISED_BEVEL.equals(inputValue)) {
            border = BorderFactory.createRaisedBevelBorder();
        } else if (LOWERED_BEVEL.equals(inputValue)) {
            border = BorderFactory.createLoweredBevelBorder();
        } else if (RAISED_ETCHED.equals(inputValue)) {
            border = BorderFactory.createEtchedBorder(0);
        } else if (LOWERED_ETCHED.equals(inputValue)) {
            border = BorderFactory.createEtchedBorder(1);
        } else if (inputValue instanceof Long || inputValue instanceof Integer) {
            int input = Integer.parseInt(String.valueOf(inputValue));
            border = BorderFactory.createLineBorder(new Color(3), input);
        } else {
            String sValue = (String)inputValue;
            String[] parts = sValue.split(" ");
            String colorValue = null;
            int width = 1;
            for (String part : parts) {
                if (colorValue == null) {
                    colorValue = part;
                    continue;
                }
                if (part.length() <= 0 || part.equals(" ")) continue;
                width = Integer.parseInt(part);
            }
            Color color = ColorAsValueHandler.getInstance().getValue(process, node, key, colorValue);
            border = BorderFactory.createLineBorder(color, width);
        }
        return border;
    }

    public Class<?> getApplicableClass() {
        return Border.class;
    }
}

