/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JSplitPane;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeHandlerAfterCreationProcessor;
import org.javabuilders.handler.ITypeHandlerFinishProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSpiltPaneTypeHandler
implements ITypeHandlerAfterCreationProcessor,
ITypeHandlerFinishProcessor {
    private static final JSpiltPaneTypeHandler singleton = new JSpiltPaneTypeHandler();
    private static final Logger logger = LoggerFactory.getLogger(JSpiltPaneTypeHandler.class);

    public static JSpiltPaneTypeHandler getInstance() {
        return singleton;
    }

    private JSpiltPaneTypeHandler() {
    }

    public void afterCreation(BuilderConfig config, BuildProcess process, Node current, String key, Map<String, Object> typeDefinition) throws BuildException {
        current.getCustomProperties().put("ignoreLayoutManager", Boolean.TRUE);
    }

    public void finish(BuilderConfig config, BuildProcess process, Node current, String key, Map<String, Object> typeDefinition) throws BuildException {
        Node content = current.getChildNode("content");
        JSplitPane pane = (JSplitPane)current.getMainObject();
        int i = 0;
        if (content != null) {
            for (Node child : content.getChildNodes()) {
                if (!(child.getMainObject() instanceof Component)) continue;
                Component c = (Component)child.getMainObject();
                if (i == 0) {
                    pane.setTopComponent(c);
                } else if (i == 1) {
                    pane.setBottomComponent(c);
                } else if (logger.isWarnEnabled()) {
                    logger.warn(MessageFormat.format("Unable to add {0} to JScrollPane. Only first two Component instances are processed", child.getKey()));
                }
                ++i;
            }
        }
    }
}

