/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.util.Collection;
import org.javabuilders.BuildException;

public class InvalidPropertyValueException
extends BuildException {
    private static final String formatMessage = "Invalid value '%s' of property '%s' for type alias '%s'. Expected value in format '%s', e.g.'%s'";
    private static final String valueMessage = "Invalid value '%s' of property '%s' for type alias '%s'. Allowed values are: %s";

    public InvalidPropertyValueException(String typeAlias, String property, Object value, Collection<? extends Object> allowedValues) {
        super(String.format(valueMessage, value, property, typeAlias, allowedValues), new Object[0]);
    }

    public InvalidPropertyValueException(String typeAlias, String property, Object value, String format, Collection<? extends Object> allowedValues, Throwable cause) {
        super(cause, String.format(valueMessage, value, property, typeAlias, allowedValues), new Object[0]);
    }

    public InvalidPropertyValueException(String typeAlias, String property, Object value, String format, String validFormatSample) {
        super(String.format(formatMessage, value, property, typeAlias, format, validFormatSample), new Object[0]);
    }

    public InvalidPropertyValueException(String typeAlias, String property, Object value, String format, String validFormatSample, Throwable cause) {
        super(cause, String.format(formatMessage, value, property, typeAlias, format, validFormatSample), new Object[0]);
    }
}

