/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler;

import java.util.Map;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.InvalidTypeException;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractTypeHandler;
import org.javabuilders.util.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTypeHandler
extends AbstractTypeHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTypeHandler.class);

    public DefaultTypeHandler() {
        super(new String[0]);
    }

    @Override
    public Node createNewInstance(BuilderConfig config, BuildProcess result, Node parent, String key, Map<String, Object> typeDefinition) throws InvalidTypeException {
        Object instance = null;
        try {
            Class<?> typeClass = BuilderUtils.getClassFromAlias(result, key, null);
            instance = typeClass.newInstance();
            if (logger.isDebugEnabled()) {
                logger.debug("Created object instance of type: {}", (Object)typeClass.getName());
            }
            return this.useExistingInstance(config, result, parent, key, typeDefinition, instance);
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error("Failed to create class {}:{}", (Object)key, (Object)ex.getMessage());
            throw new InvalidTypeException(key, ex);
        }
    }

    @Override
    public Node useExistingInstance(BuilderConfig config, BuildProcess result, Node parent, String key, Map<String, Object> typeDefinition, Object instance) throws BuildException {
        if (instance == null) {
            throw new NullPointerException("instance cannot be null");
        }
        if (!this.getApplicableClass().isInstance(instance)) {
            throw new BuildException("instance is not of type: " + this.getApplicableClass().getName(), new Object[0]);
        }
        Node node = new Node(parent, key, typeDefinition, instance);
        return node;
    }

    @Override
    public Class<?> getApplicableClass() {
        return Object.class;
    }
}

