/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.type;

import java.util.List;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeAsValueHandler;

public class IntArrayAsValueHandler
implements ITypeAsValueHandler<int[]> {
    private static final IntArrayAsValueHandler singleton = new IntArrayAsValueHandler();

    public static IntArrayAsValueHandler getInstance() {
        return singleton;
    }

    private IntArrayAsValueHandler() {
    }

    @Override
    public String getInputValueSample() {
        return "weights=(30,40,30)";
    }

    @Override
    public String getRegex() {
        return "\\[\\s*(([0-9]+\\s*)|([0-9]+\\s*,\\s*[0-9]+\\s*)+)\\s*\\]";
    }

    @Override
    public int[] getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        List values = (List)inputValue;
        int[] returnValue = new int[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            returnValue[i] = ((Long)values.get(i)).intValue();
        }
        return returnValue;
    }

    public Class<int[]> getApplicableClass() {
        return int[].class;
    }
}

