/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.validation.validator;

import org.javabuilders.BuildResult;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.handler.validation.ValidationMessage;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.handler.validation.validator.AbstractValidator;

public class MaxLengthValidator
extends AbstractValidator {
    private Integer maxLength = 0;

    public MaxLengthValidator(NamedObjectProperty property, String label, String messageFormat, BuildResult result, Integer maxLength) {
        super(property, label, messageFormat, result);
        this.maxLength = maxLength;
    }

    @Override
    public void validate(Object value, ValidationMessageList list) {
        String sValue = this.getStringValue(value);
        if (sValue != null && sValue.length() > this.maxLength) {
            list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel(), this.maxLength)));
        }
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }
}

