package net.oni2.aeinstaller.gui.about;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

import net.oni2.aeinstaller.gui.HTMLLinkLabel;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class AboutDialog extends JDialog {
	private static final long serialVersionUID = 1632257865019785612L;

	private ResourceBundle bundle = ResourceBundle.getBundle(getClass()
			.getName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JLabel lblAppversion;
	private HTMLLinkLabel txtLinks;

	/**
	 * Open the dialog
	 */
	public AboutDialog() {
		lblAppversion.setText("v"
				+ SwingJavaBuilder.getConfig().getResource("appversion"));

		txtLinks.setText(bundle.getString("Links"));

		pack();

		AbstractAction closeAction = new AbstractAction() {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		};
		KeyStroke ksCtrlW = KeyStroke
				.getKeyStroke('W', KeyEvent.CTRL_DOWN_MASK);
		getRootPane()
				.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
				.put(ksCtrlW, "close");
		getRootPane().getActionMap().put("close", closeAction);
	}

}
