package net.oni2.aeinstaller.backend;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Vector;

import net.oni2.aeinstaller.backend.Settings.Architecture;
import net.oni2.aeinstaller.backend.app_launcher.QuickAppExecution;

/**
 * @author Christian Illy
 */
public class OniSplit {

	/**
	 * @return is a .NET implementation installed?
	 */
	public static boolean isDotNETInstalled() {
		switch (Settings.getPlatform()) {
			case WIN:
				try {
					int view = WinRegistry.KEY_WOW64_32KEY;
					if (Settings.getArchitecture() == Architecture.AMD64)
						view = WinRegistry.KEY_WOW64_64KEY;

					Map<String, String> m = WinRegistry
							.readStringValues(
									WinRegistry.HKEY_LOCAL_MACHINE,
									"Software\\Microsoft\\NET Framework Setup\\NDP\\v2.0.50727",
									view);
					return m != null;
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					if (!e.getMessage()
							.equals("Registry access not supported (not a Windows OS?)."))
						// TODO Auto-generated catch block
						e.printStackTrace();
				}
				return false;
			case MACOS:
			case LINUX:
				Vector<String> cmd = new Vector<String>();
				cmd.add("which");
				cmd.add("mono");
				Vector<String> res = null;
				try {
					res = QuickAppExecution.execute(cmd);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				if (res != null) {
					if (res.get(0).startsWith("/")
							&& res.get(0).endsWith("mono")) {
						return true;
					}
				}
				return false;
			default:
				return false;
		}
	}
}
