package net.oni2.aeinstaller.backend.oni;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.Vector;

import net.oni2.aeinstaller.backend.Paths;
import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.Settings.Platform;
import net.oni2.aeinstaller.backend.mods.Mod;

import org.apache.commons.io.FileUtils;

/**
 * @author Christian Illy
 */
public class Installer {
	/**
	 * @return Is Edition Core initialized
	 */
	public static boolean isEditionInitialized() {
		return Paths.getVanillaOnisPath().exists();
	}

	private static void createEmptyPath(File path) throws IOException {
		if (path.exists())
			FileUtils.deleteDirectory(path);
		path.mkdirs();
	}

	public static void install(TreeSet<Mod> mods) {
		Vector<File> folders = new Vector<File>();
		folders.add(Paths.getVanillaOnisPath());

		for (Mod m : mods) {
			File oni = new File(m.getLocalPath(), "oni");
			if (oni.exists()) {
				if (m.hasSeparatePlatformDirs()) {
					File oniCommon = new File(oni, "common");
					File oniMac = new File(oni, "mac_only");
					File oniWin = new File(oni, "win_only");
					if (oniCommon.exists())
						folders.add(oniCommon);
					if (Settings.getPlatform() == Platform.MACOS
							&& oniMac.exists())
						folders.add(oniMac);
					else if (oniWin.exists())
						folders.add(oniWin);
				} else {
					folders.add(oni);
				}
			}
		}

		for (File f : Paths.getModsPath().listFiles()) {
			File oni = new File(f, "oni");
			if (oni.exists())
				folders.add(oni);
		}
		combineBinaryFiles(folders);

		// TODO: bsl()
	}

	private static void combineBinaryFiles(List<File> srcFolders) {
		try {
			createEmptyPath(Paths.getEditionGDF());
			HashMap<String, Vector<File>> levels = new HashMap<String, Vector<File>>();

			for (File path : srcFolders) {
				for (File levelF : path.listFiles()) {
					if (!levels.containsKey(levelF.getName().toLowerCase()))
						levels.put(levelF.getName().toLowerCase(),
								new Vector<File>());
					levels.get(levelF.getName().toLowerCase()).add(levelF);
				}
			}

			for (String l : levels.keySet()) {
				System.out.println("Level " + l);
				for (File f : levels.get(l)) {
					System.out.println("    " + f.getPath());

				}

				OniSplit.importLevel(levels.get(l),
						new File(Paths.getEditionGDF(), l + ".dat"));

				System.out.println();
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * Initializes the Edition core
	 */
	public static void initializeEdition() {
		File init = new File(Paths.getTempPath(), "init");
		try {
			createEmptyPath(Paths.getVanillaOnisPath());
			createEmptyPath(init);
			File level0Folder = new File(init, "level0_Final");
			createEmptyPath(level0Folder);
			File level0FolderVanilla = new File(Paths.getVanillaOnisPath(),
					"level0_Final");
			createEmptyPath(level0FolderVanilla);
			createEmptyPath(new File(level0FolderVanilla, "characters"));

			for (File f : Paths.getVanillaGDF().listFiles(new FilenameFilter() {
				@Override
				public boolean accept(File dir, String name) {
					return name.endsWith(".dat");
				}
			})) {
				String levelName = f.getName().substring(0,
						f.getName().indexOf('.'));
				Scanner fi = new Scanner(levelName);
				int levelNumber = Integer.parseInt(fi.findInLine("[0-9]+"));

				// Edition/GameDataFolder/level*_Final/
				File tempLevelFolder = new File(init, levelName);

				// Export Vanilla-Level-Dat -> Temp/Level
				OniSplit.export(tempLevelFolder, f);

				handleFileGlobalisation(tempLevelFolder, level0Folder,
						level0FolderVanilla, levelNumber);
			}

			for (File f : init.listFiles()) {
				String levelName = f.getName();

				// Edition/AEInstaller/vanilla/level*_Final/
				File vanillaFolder = new File(Paths.getVanillaOnisPath(),
						levelName);
				vanillaFolder.mkdirs();

				Vector<File> folders = new Vector<File>();
				folders.add(f);

				OniSplit.importLevel(folders, new File(vanillaFolder, levelName
						+ ".oni"));
			}

			// Copy Oni-configs
			File persistVanilla = new File(Paths.getOniBasePath(),
					"persist.dat");
			File persistEdition = new File(Paths.getEditionBasePath(),
					"persist.dat");
			File keyConfVanilla = new File(Paths.getOniBasePath(),
					"key_config.txt");
			File keyConfEdition = new File(Paths.getEditionBasePath(),
					"key_config.txt");
			if (persistVanilla.exists() && !persistEdition.exists())
				FileUtils.copyFile(persistVanilla, persistEdition);
			if (keyConfVanilla.exists() && !keyConfEdition.exists())
				FileUtils.copyFile(keyConfVanilla, keyConfEdition);

			// TODO: FileUtils.deleteDirectory(init);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void moveFileToTargetOrDelete(File source, File target) {
		if (source.equals(target))
			return;
		if (!target.exists()) {
			if (!source.renameTo(target)) {
				System.err.println("File " + source.getPath() + " not moved!");
			}
		} else if (!source.delete()) {
			System.err.println("File " + source.getPath() + " not deleted!");
		}
	}

	private static void handleFileGlobalisation(File tempFolder,
			File level0Folder, File level0FolderVanilla, int levelNumber) {
		// Move AKEV and related files to subfolder so they're not globalized:
		if (levelNumber != 0) {
			File akevFolder = new File(tempFolder, "AKEV");
			akevFolder.mkdir();
			OniSplit.move(akevFolder, tempFolder.getPath() + "/AKEV*.oni",
					"overwrite");
		}

		for (File f : tempFolder.listFiles(new FileFilter() {
			@Override
			public boolean accept(File pathname) {
				return pathname.isFile();
			}
		})) {
			// Move matching files to subfolder NoGlobal:
			if (f.getName().startsWith("TXMPfail")
					|| f.getName().startsWith("TXMPlevel")
					|| (f.getName().startsWith("TXMP") && f.getName().contains(
							"intro"))
					|| f.getName().startsWith("TXMB")
					|| f.getName().equals("M3GMpowerup_lsi.oni")
					|| f.getName().equals("TXMPlsi_icon.oni")
					|| (f.getName().startsWith("TXMB") && f.getName().contains(
							"splash_screen.oni"))) {
				File noGlobal = new File(tempFolder, "NoGlobal");
				noGlobal.mkdir();
				File noGlobalFile = new File(noGlobal, f.getName());
				moveFileToTargetOrDelete(f, noGlobalFile);
			}
			// Move matching files to level0_Animations/level0_TRAC
			else if (f.getName().startsWith("TRAC")) {
				File level0File = new File(level0Folder, f.getName());
				moveFileToTargetOrDelete(f, level0File);
			}
			// Move matching files to level0_Animations/level0_TRAM
			else if (f.getName().startsWith("TRAM")) {
				File level0File = new File(level0Folder, f.getName());
				moveFileToTargetOrDelete(f, level0File);
			}
			// Move matching files to level0_Textures
			else if (f.getName().startsWith("ONSK")
					|| f.getName().startsWith("TXMP")) {
				// TODO ? new File(tempFolder, "TexFix").mkdir();
				File level0File = new File(level0Folder, f.getName());
				moveFileToTargetOrDelete(f, level0File);
			}
			// Move matching files to *VANILLA*/level0_Characters
			else if (f.getName().startsWith("ONCC")
					|| f.getName().startsWith("TRBS")
					|| f.getName().startsWith("ONCV")
					|| f.getName().startsWith("ONVL")
					|| f.getName().startsWith("TRMA")
					|| f.getName().startsWith("TRSC")
					|| f.getName().startsWith("TRAS")) {
				// File level0FolderCharactersVanilla = new File(
				// level0FolderVanilla, "characters");
				// File level0FileVanilla = new File(
				// level0FolderCharactersVanilla, f.getName());
				// moveFileToTargetOrDelete(f, level0FileVanilla);
				// TODO: does this work?
				File level0File = new File(level0Folder, f.getName());
				moveFileToTargetOrDelete(f, level0File);
			}
			// Move matching files to level0_Sounds
			else if (f.getName().startsWith("OSBD")
					|| f.getName().startsWith("SNDD")) {
				File level0File = new File(level0Folder, f.getName());
				moveFileToTargetOrDelete(f, level0File);
			}
			// Move matching files to level0_Particles
			else if (f.getName().startsWith("BINA3")
					|| f.getName().startsWith("M3GMdebris")
					|| f.getName().equals("M3GMtoxic_bubble.oni")
					|| f.getName().startsWith("M3GMelec")
					|| f.getName().startsWith("M3GMrat")
					|| f.getName().startsWith("M3GMjet")
					|| f.getName().startsWith("M3GMbomb_")
					|| f.getName().equals("M3GMbarab_swave.oni")
					|| f.getName().equals("M3GMbloodyfoot.oni")) {
				File level0File = new File(level0Folder, f.getName());
				moveFileToTargetOrDelete(f, level0File);
			}
			// Move matching files to Archive (aka delete them)
			else if (f.getName().startsWith("AGDB")
					|| f.getName().startsWith("TRCM")) {
				f.delete();
			}
			// TODO: needed? ONWC to GDF instead?
			// Move matching files to *VANILLADATS*/level0_Final/level0_Final/
			// fix for buggy ONWC overriding
			else if (f.getName().startsWith("ONWC")) {
				// File level0FileVanilla = new File(level0FolderVanilla,
				// f.getName());
				// moveFileToTargetOrDelete(f, level0FileVanilla);
				// TODO: does this work?
				File level0File = new File(level0Folder, f.getName());
				moveFileToTargetOrDelete(f, level0File);
			}
		}
	}
}
