#ifndef ONI_SYMBOLS_H 
#define ONI_SYMBOLS_H
#include "bool.h"
#include <stdio.h>
#include "Oni.h"
#include "oni_gl.h"
#include "Oni_Character.h"
#include "BFW_ScriptLang.h"

#define DefVar(type, name, address) static type* _##name = (type*)address
DefVar( onibool,		ai2_deaf,				0x005ec0c1 );

DefVar(	HINSTANCE,		g_Instance,				0x0061F9E4 );

DefVar( gl_api_t*,		gl_api,					0x00560604 );
DefVar( gl_engine_t*,	gl_eng,					0x00560600 );
DefVar( WORD*,			gl_gamma_ramp,			0x0055fdfc );
DefVar( int,			gl_gamma_ramp_valid,	0x005603fc );

DefVar(	char,			opt_ignore_private_data,0x006370f0 );
DefVar( char,			opt_sound,				0x006370fc ); 

DefVar( char,			AKgDebug_DebugMaps,		0x002b2204 );

DefVar( bool,			BFgDebugFileEnable,		0x0055c8d0 );

DefVar( uint32_t,		COgConsoleLines,		0x005cb468 );
DefVar( uint32_t,		COgDefaultTextShade,	0x00533f70 );
DefVar( uint32_t,		COgDefaultTextShadow,	0x00533f74 );
DefVar( uint32_t,		COgFadeTimeValue,		0x00533f68 );

DefVar( FILE*,			ONgFileStartup,			0x005711b8 );
DefVar( GameState*,		ONgGameState,			0x005ece7c );
DefVar( ONtPlatformData,ONgPlatformData,		0x0053100c );

DefVar( char,			M3gResolutionSwitch,	0x00531634 );

DefVar( bool,			SSgSearchOnDisk,		0x005eb758 );
#undef DefVar
//Yes, I'm aware that there are a few ways this could go wrong
//but in the interests of neatness and not having to go through and rename all the variables
//and use annoying dereferencing, this will do.

//...too bad there is no way to nest #defines...
#define AKgDebug_DebugMaps (*_AKgDebug_DebugMaps)
#define ai2_deaf (*_ai2_deaf)
#define g_Instance (*_g_Instance)
#define M3gResolutionSwitch (*_M3gResolutionSwitch)
#define ONgGameState (*_ONgGameState)
#define ONgPlatformData (*_ONgPlatformData)
#define opt_ignore_private_data (*_opt_ignore_private_data)
#define opt_sound (*_opt_sound)
#define BFgDebugFileEnable (*_BFgDebugFileEnable)
#define SSgSearchOnDisk (*_SSgSearchOnDisk)
#define gl_gamma_ramp (*_gl_gamma_ramp)
#define gl_gamma_ramp_valid (*_gl_gamma_ramp_valid)
#define gl_api (*_gl_api)
#define gl_eng (*_gl_eng)
#define COgConsoleLines (*_COgConsoleLines)
#define COgFadeTimeValue (*_COgFadeTimeValue)
#define COgDefaultTextShade (*_COgDefaultTextShade)
#define COgDefaultTextShadow (*_COgDefaultTextShadow)
#define ONgFileStartup (*_ONgFileStartup)


typedef uint16_t	( ONICALL *sl_func)(sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], int* dontuse1, int* dontuse2, sl_arg* ret);
typedef char		( ONICALL *OBJtEnumCallback_Object)(void *inObject, int inUserData);


#undef DefFunc
#define DefFunc( type, name, callingconvention, args, address) typedef type ( callingconvention * _##name ) args; static _##name name = (_##name)address
DefFunc(int64_t, UUrMachineTime_High, ONICALL, (), 0x04026480);
DefFunc(double, UUrMachineTime_High_Frequency, ONICALL, (), 0x040264b0);
DefFunc(int64_t, UUrMachineTime_Sixtieths, ONICALL, (), 0x040263e0);
DefFunc(void, UUrPlatform_Initialize, ONICALL, (), 0x04026010);
DefFunc(void, UUrPlatform_Terminate, ONICALL, (), 0x04026310);

DefFunc(FILE*, oni_fopen, __cdecl, (const char*, const char*), 0x0051ea9f);
DefFunc(int, oni_fprintf, __cdecl, (FILE*, const char*, ...), 0x0051ebbf);
DefFunc(int, oni_fflush, __cdecl, (FILE*), 0x0051eab2);

DefFunc(void, ONiMain, __cdecl, (int ArgCount, char *ArgList[]), 0x004d3280);
DefFunc(short, ONrPlatform_Initialize, ONICALL, (ONtPlatformData *PlatformData), 0x0050f670);
DefFunc(LRESULT, ONrPlatform_WindowProc, CALLBACK, (HWND Window, UINT Message, WPARAM WParam, LPARAM LParam), 0x0050f7a0);
DefFunc(unsigned int, gl_enumerate_valid_display_modes, ONICALL, (M3tDisplayMode modes[16]), 0x004083a0);
DefFunc(int, gl_platform_set_pixel_format, ONICALL, (HDC hdc), 0x00407b50);
DefFunc(int, gl_platform_initialize, ONICALL, (), 0x00407da0);

DefFunc(float, ONrPersist_GetGamma, ONICALL, (), 0x0050f450);
DefFunc(uint8_t, ONrPersist_GetWonGame, ONICALL, (), 0x0050f660);

DefFunc(void, UUrStartupMessage, __cdecl, (const char* fmt, ...), 0x00424860);
DefFunc(int16_t, ONrGameState_NewCharacter, ONICALL, (void* CHAR, void* AISA, void* flag, uint32_t* list_location), 0x004dac50);
DefFunc(ActiveCharacter*, ONrGetActiveCharacter, ONICALL, (void* CharacterPtr), 0x004f1180);
DefFunc(void, ONrCharacter_NewAnimationHook, ONICALL, (Character *ioCharacter, ActiveCharacter *ioActiveCharacter), 0x004E97A0);
DefFunc(void, ONrCharacter_SetAnimationExternal, ONICALL, (Character *ioCharacter, short state, void* animation, int interpolation), 0x004EB340);

DefFunc(void, COrTextArea_Print, ONICALL, (uint32_t area, uint32_t priority, uint32_t textshade, uint32_t textshadowshade, const char* text, uint32_t unk_alwaws_0, uint32_t fadetime), 0x00431340);
DefFunc(uint8_t, ONrCheater, ONICALL, (uint32_t cheat), 0x004f5c30);
DefFunc(int, AUrMessageBox, __cdecl, (int Buttons, char *Message, ...), 0x004378c0);
DefFunc(char*, SSrMessage_Find, ONICALL, (char* message_key), 0x0047F550);
DefFunc(void, ONiGameState_FindAutoPromptMessage, ONICALL, (char* Note, void* ptr), 0x004FDBE0);

DefFunc(uint16_t, SLrScript_Command_Register_ReturnType, ONICALL, (char* name, char* desc, char* argfmt, sl_type type, sl_func callback), 0x00477b20);
DefFunc(uint16_t, SLrScript_Command_Register_Void, ONICALL, (char* name, char* desc, char* argfmt, sl_func callback), 0x00477b40);
DefFunc(uint16_t, SLrGlobalVariable_Register_Int32, ONICALL, (char* name, char* desc, int32_t* data), 0x00477e30);
DefFunc(uint16_t, SLrGlobalVariable_Register_Float, ONICALL, (char* name, char* desc, float* data), 0x00477ec0);
DefFunc(uint16_t, SLrGlobalVariable_Register_String, ONICALL, (char* name, char* desc, char* data), 0x00477fe0);

DefFunc(int, COrMessage_Print, ONICALL, (char* Message, char* Key, void* noidea), 0x004304B0);
DefFunc(void, COrConsole_StatusLine_Display, ONICALL, (), 0x00431E70);
DefFunc(int16_t, TMrInstance_GetDataPtr, ONICALL, (int tag, char* name, void* pointer), 0x004232E0);
DefFunc(char*, TMrInstance_GetInstanceName, ONICALL, (void* InstancePointer), 0x00423D90);

DefFunc(int16_t, TSrContext_DrawText, ONICALL, (uint32_t TSrContext, char* Text, char alpha, uint32_t usuallyzero, void* pRect), 0x0042DF00);
DefFunc(int16_t, TSrContext_New, ONICALL, (void* FontInstance, int size, int hthsik1,int hthsik2,int hthsik3, void* TSrContext), 0x0042EA30);

DefFunc(int16_t, TSrContext_SetShade, ONICALL, (void *ioTextContext, uint32_t inShade), 0x0042EE50);
DefFunc(void, ONrGameState_Timer_Start, ONICALL, (char* function, int time), 0x004FD370);
DefFunc(uint16_t, TRrAnimation_GetDuration, ONICALL, (void* Animation), 0x00428740);
DefFunc(uint16_t, TRrAnimation_GetTo, ONICALL, (void* Animation), 0x00428730);
DefFunc(uint16_t, TRrAnimation_GetFrom, ONICALL, (void* Animation), 0x00428720);

DefFunc(void, ONrCharacter_SetHitPoints, ONICALL, (Character *ioCharacter, uint32_t inHitPoints), 0x004EB220);
DefFunc(void, ONrCorpse_Create, ONICALL, (Character* Character), 0x004EF340);

DefFunc(uint16_t, iSetCharacterClass, ONICALL, (sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], int* dontuse1, int* dontuse2, sl_arg* ret), 0x004D99D0);
DefFunc(uint16_t, AI2iScript_Spawn, ONICALL, (sl_callinfo* callinfo, uint32_t numargs, sl_arg args[], int* dontuse1, int* dontuse2, sl_arg* ret), 0x004B4780);
//NOT USED: DefFunc(void*, OBJrObjectType_GetObject_ByNumber, ONICALL, (int inObjectType, int inIndex), );
//NOT USED: DefFunc(int, OBJiObjectGroup_GetNumObjects, ONICALL, (void *inObjectGroup), );

DefFunc(void, ONrGameState_DeleteCharacter, ONICALL, (Character *inCharacter), 0x004DC480);

DefFunc(int, OBJrObjectType_EnumerateObjects, ONICALL, (int inObjectType, OBJtEnumCallback_Object inEnumCallback, int inUserData), 0x004D0080);

DefFunc(void, OBJrDoor_Open, ONICALL, (DoorObject *inObject, Character *inCharacter), 0x004C26C0);
DefFunc(void, OBJrDoor_ForceOpen, ONICALL, (short id), 0x004C1EE0);
DefFunc(short, OBJrConsole_OnActivate, ONICALL, (void *inObject, Character *inCharacter), 0x004C0880);
DefFunc(void*, OBJrConsole_GetByID, ONICALL, (short ID), 0x004C0950);


DefFunc(void, ONrCharacter_SetCharacterClass, ONICALL, (Character* Char, ONCC* Class), 0x004D7C30);
DefFunc(short, TMrInstance_GetDataPtr_ByNumber, ONICALL, (int tag, int number, void** out), 0x00423680);
DefFunc(uint32_t, TMrInstance_GetTagCount, ONICALL, (int tag), 0x004236F0);
DefFunc(uint32_t, ONrCharacter_GetHealthShade, ONICALL, (uint32_t health, uint32_t maxhealth), 0x004EF450);
DefFunc(void, ONiDrawWeaponSight, ONICALL, (Character* Char), 0x004E1900);
DefFunc(void, AI2rDisplayDebuggingInfo, ONICALL, (Character* Char), 0x0048C5F0);
DefFunc(uint32_t, M3rTextureMap_New, ONICALL, (short width, short height, int type, int allocated, int flags, char* name, void** output), 0x041EB00);
#undef DefFunc

#endif
