package net.oni2.aeinstaller.backend;

import java.io.File;
import java.io.FilenameFilter;

/**
 * @author Christian Illy
 */
public class CaseInsensitiveFile {
	/**
	 * Get a File for the given parent path and a child name. Return the name as
	 * passed to the function if either parent or a file named that way does not
	 * exist.
	 * 
	 * @param parent
	 *            Parent path
	 * @param name
	 *            Name of file
	 * @return File
	 */
	public static File getCaseInsensitiveFile(File parent, final String name) {
		if (parent.exists()) {
			for (File f : parent.listFiles(new FilenameFilter() {
				@Override
				public boolean accept(File dir, String fname) {
					return fname.equalsIgnoreCase(name);
				}
			})) {
				return f;
			}
		}
		return new File(parent, name);
	}
}
